/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.listeners;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import me.limeglass.skungee.bungeecord.Skungee;
import me.limeglass.skungee.bungeecord.sockets.BungeeSockets;
import me.limeglass.skungee.bungeecord.sockets.ServerTracker;
import me.limeglass.skungee.objects.BungeePacket;
import me.limeglass.skungee.objects.BungeePacketType;
import me.limeglass.skungee.objects.ConnectedServer;
import me.limeglass.skungee.objects.ServerPingPacket;
import me.limeglass.skungee.objects.SkungeePlayer;
import net.md_5.bungee.api.Favicon;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import net.md_5.bungee.protocol.ProtocolConstants;

public class EventListener
implements Listener {
    @EventHandler
    public void onServerSwitch(ServerSwitchEvent event) {
        if (event.getPlayer() != null) {
            SkungeePlayer player = new SkungeePlayer(false, event.getPlayer().getUniqueId(), event.getPlayer().getName());
            if (event.getPlayer().getServer() != null) {
                BungeePacket packet = new BungeePacket(Boolean.valueOf(false), BungeePacketType.PLAYERSWITCH, (Object)event.getPlayer().getServer().getInfo().getName(), new SkungeePlayer[]{null, player});
                BungeeSockets.sendAll((BungeePacket)packet);
            }
        }
    }

    @EventHandler
    public void onDisconnect(PlayerDisconnectEvent event) {
        if (event.getPlayer() != null) {
            SkungeePlayer player = new SkungeePlayer(false, event.getPlayer().getUniqueId(), event.getPlayer().getName());
            if (event.getPlayer().getServer() != null) {
                ConnectedServer[] servers = ServerTracker.get(event.getPlayer().getServer().getInfo().getName());
                if (servers == null) {
                    return;
                }
                BungeePacket packet = new BungeePacket(Boolean.valueOf(false), BungeePacketType.PLAYERDISCONNECT, (Object)servers[0].getName(), new SkungeePlayer[]{null, player});
                BungeeSockets.sendAll((BungeePacket)packet);
            }
        }
    }

    @EventHandler
    public void onPing(ProxyPingEvent event) {
        if (event.getResponse() != null && !Skungee.getConfig().getBoolean("DisablePingEvent", false)) {
            ServerPing ping = event.getResponse();
            ServerPingPacket packet = new ServerPingPacket(Boolean.valueOf(true), BungeePacketType.SERVERLISTPING, (Object)ProtocolConstants.SUPPORTED_VERSION_IDS);
            packet.setVersion(ping.getVersion().getName() + ":" + ping.getVersion().getProtocol());
            packet.setDescription(ping.getDescriptionComponent().toLegacyText());
            if (ping.getPlayers().getSample() != null) {
                ServerPing.PlayerInfo[] playerInfo = ping.getPlayers().getSample();
                SkungeePlayer[] players = new SkungeePlayer[playerInfo.length];
                int i = 0;
                for (ServerPing.PlayerInfo info : playerInfo) {
                    players[i] = new SkungeePlayer(false, info.getUniqueId(), info.getName());
                    ++i;
                }
                packet.setPlayers(players);
            }
            for (Object object : BungeeSockets.sendAll((BungeePacket)packet)) {
                String[] protocol;
                if (object == null) continue;
                ServerPingPacket returned = (ServerPingPacket)object;
                String input = Skungee.cc(returned.getDescription().replaceAll(Pattern.quote("\\n"), "\n"));
                if (returned.getDescription() != null) {
                    ping.setDescriptionComponent((BaseComponent)new TextComponent(input));
                }
                if (returned.getVersion() != null && (protocol = returned.getVersion().split(Pattern.quote(":"))).length > 1) {
                    ping.setVersion(new ServerPing.Protocol(protocol[0], Integer.parseInt(protocol[1])));
                }
                if (returned.getFavicon() != null) {
                    String location = returned.getFavicon();
                    try {
                        BufferedImage image;
                        File file = new File(location);
                        if (file.exists() && (location.endsWith(".png") || location.endsWith(".jpg"))) {
                            image = ImageIO.read(file);
                            if (image.getWidth() != 64 || image.getHeight() != 64) {
                                Skungee.consoleMessage("The image at location " + location + " must be exactly 64x64 pixels.");
                                image = null;
                            }
                        } else {
                            Skungee.consoleMessage("test");
                            image = ImageIO.read(new URL(location));
                        }
                        if (image != null) {
                            ping.setFavicon(Favicon.create((BufferedImage)image));
                        }
                    }
                    catch (IOException e) {
                        Skungee.infoMessage("Could not find URL/Image under " + location + " or the website did not allow/return properly. You can use https://imgur.com/ which is a valid image hosting website.");
                    }
                }
                if (returned.getPlayers() == null) continue;
                ServerPing.PlayerInfo[] info = new ServerPing.PlayerInfo[returned.getPlayers().length];
                int spot = 0;
                for (SkungeePlayer player : returned.getPlayers()) {
                    info[spot] = new ServerPing.PlayerInfo(player.getName(), player.getUUID());
                    ++spot;
                }
                ping.getPlayers().setSample(info);
            }
            event.setResponse(ping);
        }
    }
}

