/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.handlers;

import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.util.HashSet;
import me.limeglass.skungee.bungeecord.handlercontroller.SkungeeBungeeHandler;
import me.limeglass.skungee.bungeecord.handlercontroller.SkungeeHandler;
import me.limeglass.skungee.bungeecord.variables.VariableManager;
import me.limeglass.skungee.objects.SkungeeEnums;
import me.limeglass.skungee.objects.SkungeeVariable;
import me.limeglass.skungee.objects.packets.SkungeePacket;
import me.limeglass.skungee.objects.packets.SkungeePacketType;

public class NetworkVariableHandler
extends SkungeeBungeeHandler {
    static {
        NetworkVariableHandler.registerHandler((SkungeeHandler)new NetworkVariableHandler(), SkungeePacketType.NETWORKVARIABLE);
    }

    public SkungeeVariable.Value[] handlePacket(SkungeePacket packet, InetAddress address) {
        Object object = packet.getObject();
        if (object == null) {
            return null;
        }
        if (object instanceof SkungeeVariable) {
            SkungeeVariable variable = (SkungeeVariable)object;
            String variableName = variable.getVariableName();
            SkungeeVariable.Value[] values = variable.getValues();
            if (values == null || variableName == null) {
                return null;
            }
            SkungeeEnums.SkriptChangeMode mode = packet.getChangeMode();
            if (mode != null) {
                HashSet modify = new HashSet();
                Object[] data = VariableManager.getMainStorage().get(variableName);
                if (data != null) {
                    modify = Sets.newHashSet((Object[])data);
                }
                switch (mode) {
                    case ADD: {
                        VariableManager.getMainStorage().remove(variableName);
                        SkungeeVariable.Value[] valueArray = values;
                        int n = values.length;
                        int n2 = 0;
                        while (n2 < n) {
                            SkungeeVariable.Value value = valueArray[n2];
                            modify.add(value);
                            ++n2;
                        }
                        VariableManager.getMainStorage().set(variableName, modify.toArray(new SkungeeVariable.Value[modify.size()]));
                        break;
                    }
                    case REMOVE: 
                    case REMOVE_ALL: {
                        VariableManager.getMainStorage().remove(variableName);
                        SkungeeVariable.Value[] valueArray = values;
                        int n = values.length;
                        int n3 = 0;
                        while (n3 < n) {
                            SkungeeVariable.Value value = valueArray[n3];
                            modify.remove(value);
                            ++n3;
                        }
                        VariableManager.getMainStorage().set(variableName, modify.toArray(new SkungeeVariable.Value[modify.size()]));
                        break;
                    }
                    case DELETE: 
                    case RESET: {
                        VariableManager.getMainStorage().remove(variableName);
                        break;
                    }
                    case SET: {
                        VariableManager.getMainStorage().set(variableName, values);
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (object instanceof String && packet.getChangeMode() == null) {
            return VariableManager.getMainStorage().get((String)object);
        }
        return null;
    }
}

