/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.handlers;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import me.limeglass.skungee.UniversalSkungee;
import me.limeglass.skungee.bungeecord.Skungee;
import me.limeglass.skungee.bungeecord.handlercontroller.SkungeeBungeeHandler;
import me.limeglass.skungee.bungeecord.handlercontroller.SkungeeHandler;
import me.limeglass.skungee.bungeecord.sockets.ServerTracker;
import me.limeglass.skungee.objects.packets.SkungeePacket;
import me.limeglass.skungee.objects.packets.SkungeePacketType;
import net.md_5.bungee.api.config.ServerInfo;

public class HeartbeatHandler
extends SkungeeBungeeHandler {
    static {
        HeartbeatHandler.registerHandler((SkungeeHandler)new HeartbeatHandler(), SkungeePacketType.HEARTBEAT);
    }

    @Override
    public Object handlePacket(SkungeePacket packet, InetAddress address) {
        if (packet.getObject() == null) {
            return null;
        }
        int port = (Integer)packet.getObject();
        for (Map.Entry server : this.servers.entrySet()) {
            InetSocketAddress inetaddress = new InetSocketAddress(address, port);
            try {
                if (!((ServerInfo)server.getValue()).getAddress().equals(inetaddress) && !Inet4Address.getLocalHost().getHostAddress().equals(address.getHostAddress())) continue;
                return ServerTracker.update((String)server.getKey());
            }
            catch (UnknownHostException error) {
                Skungee.exception(error, "Unknown host: " + inetaddress);
            }
        }
        return null;
    }

    @Override
    public String toString(SkungeePacket packet) {
        return Skungee.getConfig().getBoolean("IgnoreSpamPackets", true) ? null : UniversalSkungee.getPacketDebug(packet);
    }
}

