/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import me.limeglass.skungee.spigot.Skungee;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class SpigotConfigSaver {
    private final File folder;
    private final File config;
    private final File oldconfig;
    private FileConfiguration configuration;

    public SpigotConfigSaver(Skungee instance) {
        this.folder = new File(instance.getDataFolder(), "old-configs/");
        this.config = new File(instance.getDataFolder(), "config.yml");
        this.load();
        this.oldconfig = new File(this.folder, String.valueOf(this.configuration.getString("version", "old")) + "-config.yml");
        if (!this.folder.exists()) {
            this.folder.mkdir();
        }
    }

    private void load() {
        this.configuration = new YamlConfiguration();
        try {
            this.configuration.load(this.config);
        }
        catch (IOException | InvalidConfigurationException exception) {
            Skungee.exception(exception, "Failed to load the configuration.");
        }
    }

    public void execute() {
        try {
            Files.move((File)this.config, (File)this.oldconfig);
        }
        catch (IOException exception) {
            Skungee.exception(exception, "Failed to save the old configuration.");
        }
    }
}

