/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.sockets;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Config;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.variables.Variables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.limeglass.skungee.UniversalSkungee;
import me.limeglass.skungee.objects.BungeePacket;
import me.limeglass.skungee.objects.BungeePacketType;
import me.limeglass.skungee.objects.ServerPingPacket;
import me.limeglass.skungee.objects.events.PingEvent;
import me.limeglass.skungee.objects.events.PlayerDisconnectEvent;
import me.limeglass.skungee.objects.events.PlayerSwitchServerEvent;
import me.limeglass.skungee.objects.events.SkungeeMessageEvent;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.sockets.SpigotPacketHandler;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;

public class SpigotPacketHandler {
    public static Object handlePacket(BungeePacket packet, InetAddress address) {
        if (!Skungee.getInstance().getConfig().getBoolean("IgnoreSpamPackets", true)) {
            Skungee.debugMessage("Recieved " + UniversalSkungee.getPacketDebug((BungeePacket)packet));
        } else if (packet.getType() != BungeePacketType.GLOBALSCRIPTS) {
            Skungee.debugMessage("Recieved " + UniversalSkungee.getPacketDebug((BungeePacket)packet));
        }
        switch (2.$SwitchMap$me$limeglass$skungee$objects$BungeePacketType[packet.getType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (packet.getObject() == null || packet.getPlayers() == null) break;
                Bukkit.getPluginManager().callEvent((Event)new PlayerDisconnectEvent((String)packet.getObject(), packet.getFirstPlayer()));
                break;
            }
            case 4: {
                if (packet.getObject() == null || packet.getPlayers() == null) break;
                Bukkit.getPluginManager().callEvent((Event)new PlayerSwitchServerEvent((String)packet.getObject(), packet.getFirstPlayer()));
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                if (packet.getObject() == null) break;
                for (String effect : (String[])packet.getObject()) {
                    if (Effect.parse((String)effect, null) == null) {
                        Skungee.infoMessage("There was an error executing effect: " + effect);
                        Skungee.infoMessage("Possibly not an effect for this server? Make sure you have any addons that could run this effect and that it looks realistic.");
                        continue;
                    }
                    Effect.parse((String)effect, null).run(null);
                }
                break;
            }
            case 8: {
                File scriptsFolder = new File(Skript.getInstance().getDataFolder().getAbsolutePath() + File.separator + "scripts");
                Set<File> scripts = SpigotPacketHandler.getFiles(scriptsFolder, new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".sk") && !name.startsWith("-");
                    }
                });
                Map data = (Map)packet.getObject();
                for (Map.Entry entry : data.entrySet()) {
                    try {
                        if (scripts.stream().anyMatch(file -> file.getName().equals(entry.getKey()))) {
                            Boolean reload = false;
                            File script = File.createTempFile("Skungee", (String)entry.getKey());
                            PrintStream out = new PrintStream(new FileOutputStream(script));
                            out.print(StringUtils.join((Collection)((Collection)entry.getValue()), (char)'\n'));
                            out.close();
                            for (File similar : scripts.stream().filter(file -> file.getName().equals(entry.getKey())).collect(Collectors.toSet())) {
                                if (Arrays.equals(Files.readAllBytes(script.toPath()), Files.readAllBytes(similar.toPath()))) continue;
                                Files.deleteIfExists(similar.toPath());
                                reload = true;
                            }
                            if (reload.booleanValue()) {
                                File newScript = new File(scriptsFolder + File.separator + (String)entry.getKey());
                                com.google.common.io.Files.move((File)script, (File)newScript);
                                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("sk reload " + (String)entry.getKey()));
                                if (Skungee.getInstance().getConfig().getBoolean("GlobalScriptMessages", true)) {
                                    Skungee.consoleMessage("&6GlobalScripts: reloaded script " + (String)entry.getKey() + " for this server!");
                                }
                            }
                            script.delete();
                            continue;
                        }
                        File script = new File(scriptsFolder + File.separator + (String)entry.getKey());
                        PrintStream out = new PrintStream(new FileOutputStream(script));
                        out.print(StringUtils.join((Collection)((Collection)entry.getValue()), (char)'\n'));
                        out.close();
                        String name = scriptsFolder + File.separator + script.getName();
                        Config config = new Config((InputStream)new FileInputStream(script), name, script, true, false, ":");
                        ScriptLoader.loadScripts((Config[])new Config[]{config});
                        if (!Skungee.getInstance().getConfig().getBoolean("GlobalScriptMessages", true)) continue;
                        Skungee.consoleMessage("&6GlobalScripts: created script " + (String)entry.getKey() + " for this server!");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                break;
            }
            case 9: {
                String ID = (String)packet.getObject();
                Variables.setVariable((String)ID, (Object)packet.getSetObject(), null, (boolean)false);
                break;
            }
            case 10: {
                Bukkit.shutdown();
                break;
            }
            case 11: {
                if (!(packet instanceof ServerPingPacket)) break;
                PingEvent event = new PingEvent((ServerPingPacket)packet);
                Bukkit.getPluginManager().callEvent((Event)event);
                return event.getPacket();
            }
            case 12: {
                if (packet.getObject() == null || packet.getSetObject() == null) break;
                for (String channel : (String[])packet.getSetObject()) {
                    Bukkit.getPluginManager().callEvent((Event)new SkungeeMessageEvent(channel, (String[])packet.getObject()));
                }
                break;
            }
        }
        return null;
    }

    private static Set<File> getFiles(File root, FilenameFilter filter, Set<File> toAdd) {
        for (File file : root.listFiles()) {
            if (file.isDirectory()) {
                toAdd.addAll(SpigotPacketHandler.getFiles(file, filter, toAdd));
                continue;
            }
            if (!filter.accept(file, file.getName())) continue;
            toAdd.add(file);
        }
        return toAdd;
    }

    private static Set<File> getFiles(File root, FilenameFilter filter) {
        HashSet<File> files = new HashSet<File>();
        for (File file : root.listFiles()) {
            if (file.isDirectory()) {
                files.addAll(SpigotPacketHandler.getFiles(file, filter, files));
                continue;
            }
            if (!filter.accept(file, file.getName())) continue;
            files.add(file);
        }
        return files;
    }
}

