/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee;

import java.util.Arrays;
import java.util.stream.Collectors;
import me.limeglass.skungee.objects.BungeePacket;
import me.limeglass.skungee.objects.BungeePacketType;
import me.limeglass.skungee.objects.SkungeePacket;
import me.limeglass.skungee.objects.SkungeePlayer;

public class UniversalSkungee {
    private static Boolean isBungeecord = false;

    public static Boolean isBungeecord() {
        return isBungeecord;
    }

    public static void setBungeecord(Boolean bungeecord) {
        isBungeecord = bungeecord;
    }

    public static String getPacketDebug(SkungeePacket packet) {
        String debug = "packet: " + (Object)((Object)packet.getType());
        if (packet.getObject() != null) {
            debug = packet.getObject().getClass().isArray() ? String.valueOf(debug) + " with data: " + Arrays.toString((Object[])packet.getObject()) : String.valueOf(debug) + " with data: " + packet.getObject();
        }
        if (packet.getSetObject() != null) {
            debug = packet.getSetObject().getClass().isArray() ? String.valueOf(debug) + " with settable data: " + Arrays.toString((Object[])packet.getSetObject()) : String.valueOf(debug) + " with settable data: " + packet.getSetObject();
        }
        if (packet.getPlayers() != null) {
            debug = String.valueOf(debug) + " for players: " + Arrays.stream(packet.getPlayers()).map(SkungeePlayer::getName).collect(Collectors.toList());
        }
        return debug;
    }

    public static String getPacketDebug(BungeePacket packet) {
        String debug = "packet: " + (Object)((Object)packet.getType());
        if (packet.getObject() != null && packet.getType() != BungeePacketType.GLOBALSCRIPTS) {
            debug = packet.getObject().getClass().isArray() ? String.valueOf(debug) + " with data: " + Arrays.toString((Object[])packet.getObject()) : String.valueOf(debug) + " with data: " + packet.getObject();
        }
        if (packet.getSetObject() != null) {
            debug = packet.getSetObject().getClass().isArray() ? String.valueOf(debug) + " with settable data: " + Arrays.toString((Object[])packet.getSetObject()) : String.valueOf(debug) + " with settable data: " + packet.getSetObject();
        }
        if (packet.getPlayers() != null) {
            debug = String.valueOf(debug) + " for players: " + Arrays.stream(packet.getPlayers()).map(SkungeePlayer::getName).collect(Collectors.toList());
        }
        return debug;
    }
}

