/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.sockets;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Config;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.variables.Variables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.limeglass.skungee.UniversalSkungee;
import me.limeglass.skungee.objects.BungeePacket;
import me.limeglass.skungee.objects.BungeePacketType;
import me.limeglass.skungee.objects.events.PlayerDisconnectEvent;
import me.limeglass.skungee.objects.events.PlayerSwitchServerEvent;
import me.limeglass.skungee.spigot.Skungee;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class SpigotPacketHandler {
    public static Object handlePacket(final BungeePacket packet, InetAddress address) {
        if (!Skungee.getInstance().getConfig().getBoolean("IgnoreSpamPackets", true)) {
            Skungee.debugMessage("Recieved " + UniversalSkungee.getPacketDebug(packet));
        } else if (packet.getType() != BungeePacketType.GLOBALSCRIPTS) {
            Skungee.debugMessage("Recieved " + UniversalSkungee.getPacketDebug(packet));
        }
        switch (packet.getType()) {
            case PINGSERVER: {
                break;
            }
            case PLAYERCHAT: {
                break;
            }
            case PLAYERDISCONNECT: {
                if (packet.getObject() == null || packet.getPlayers() == null) break;
                Bukkit.getPluginManager().callEvent((Event)new PlayerDisconnectEvent((String)packet.getObject(), packet.getFirstPlayer()));
                break;
            }
            case PLAYERSWITCH: {
                if (packet.getObject() == null || packet.getPlayers() == null) break;
                Bukkit.getScheduler().runTask((Plugin)Skungee.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        Bukkit.getPluginManager().callEvent((Event)new PlayerSwitchServerEvent((String)packet.getObject(), packet.getFirstPlayer()));
                    }
                });
                break;
            }
            case PLAYERLOGIN: {
                break;
            }
            case PLAYERCOMMAND: {
                break;
            }
            case EVALUATE: {
                if (packet.getObject() == null) break;
                String[] stringArray = (String[])packet.getObject();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String effect = stringArray[n2];
                    if (Effect.parse((String)effect, null) == null) {
                        Skungee.infoMessage("There was an error executing effect: " + effect);
                        Skungee.infoMessage("Possibly not an effect for this server? Make sure you have any addons that could run this effect and that it looks realistic.");
                    } else {
                        Effect.parse((String)effect, null).run(null);
                    }
                    ++n2;
                }
                break;
            }
            case GLOBALSCRIPTS: {
                File scriptsFolder = new File(String.valueOf(Skript.getInstance().getDataFolder().getAbsolutePath()) + File.separator + "scripts");
                Set<File> scripts = SpigotPacketHandler.getFiles(scriptsFolder, new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".sk") && !name.startsWith("-");
                    }
                });
                Map data = (Map)packet.getObject();
                for (Map.Entry entry : data.entrySet()) {
                    try {
                        if (scripts.stream().anyMatch(file -> file.getName().equals(entry.getKey()))) {
                            Boolean reload = false;
                            File script = File.createTempFile("Skungee", (String)entry.getKey());
                            PrintStream out = new PrintStream(new FileOutputStream(script));
                            out.print(StringUtils.join((Collection)((Collection)entry.getValue()), (char)'\n'));
                            out.close();
                            for (File similar : scripts.stream().filter(file -> file.getName().equals(entry.getKey())).collect(Collectors.toSet())) {
                                if (Arrays.equals(Files.readAllBytes(script.toPath()), Files.readAllBytes(similar.toPath()))) continue;
                                try {
                                    Method method = ScriptLoader.class.getDeclaredMethod("unloadScript", File.class);
                                    method.setAccessible(true);
                                    method.invoke(ScriptLoader.class, similar);
                                }
                                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException error) {
                                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("/sk unload " + (String)entry.getKey()));
                                }
                                Files.deleteIfExists(similar.toPath());
                                reload = true;
                            }
                            if (reload.booleanValue()) {
                                File newScript = new File(scriptsFolder + File.separator + (String)entry.getKey());
                                com.google.common.io.Files.move((File)script, (File)newScript);
                                String name = scriptsFolder + File.separator + newScript.getName();
                                Config config = new Config((InputStream)new FileInputStream(newScript), name, newScript, true, false, ":");
                                ScriptLoader.loadScripts((Config[])new Config[]{config});
                                if (Skungee.getInstance().getConfig().getBoolean("GlobalScriptMessages", true)) {
                                    Skungee.consoleMessage("&6GlobalScripts: reloaded script " + (String)entry.getKey() + " for this server!");
                                }
                            }
                            script.delete();
                            continue;
                        }
                        File script = new File(scriptsFolder + File.separator + (String)entry.getKey());
                        PrintStream out = new PrintStream(new FileOutputStream(script));
                        out.print(StringUtils.join((Collection)((Collection)entry.getValue()), (char)'\n'));
                        out.close();
                        String name = scriptsFolder + File.separator + script.getName();
                        Config config = new Config((InputStream)new FileInputStream(script), name, script, true, false, ":");
                        ScriptLoader.loadScripts((Config[])new Config[]{config});
                        if (!Skungee.getInstance().getConfig().getBoolean("GlobalScriptMessages", true)) continue;
                        Skungee.consoleMessage("&6GlobalScripts: created script " + (String)entry.getKey() + " for this server!");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                break;
            }
            case UPDATEVARIABLES: {
                String ID = (String)packet.getObject();
                Variables.setVariable((String)ID, (Object)packet.getSetObject(), null, (boolean)false);
            }
        }
        return null;
    }

    private static Set<File> getFiles(File root, FilenameFilter filter, Set<File> toAdd) {
        File[] fileArray = root.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                toAdd.addAll(SpigotPacketHandler.getFiles(file, filter, toAdd));
            } else if (filter.accept(file, file.getName())) {
                toAdd.add(file);
            }
            ++n2;
        }
        return toAdd;
    }

    private static Set<File> getFiles(File root, FilenameFilter filter) {
        HashSet<File> files = new HashSet<File>();
        File[] fileArray = root.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                files.addAll(SpigotPacketHandler.getFiles(file, filter, files));
            } else if (filter.accept(file, file.getName())) {
                files.add(file);
            }
            ++n2;
        }
        return files;
    }
}

