/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.lang;

import ch.njol.skript.lang.Expression;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class ExpressionData {
    private Expression<?>[] expressions;
    private Map<String, Integer> syntax = new HashMap<String, Integer>();
    public boolean nullable = false;

    public ExpressionData(Expression<?>[] expressions, String pattern) {
        Matcher matcher = Pattern.compile("\\%([^\\%]+)\\%").matcher(pattern);
        int i = 0;
        while (matcher.find()) {
            String expression = matcher.group(1);
            while (expression.startsWith("-") || expression.startsWith("~") || expression.startsWith("*")) {
                if (expression.startsWith("-")) {
                    this.nullable = true;
                }
                expression = expression.substring(1, expression.length());
            }
            if (expression.endsWith("s")) {
                expression = expression.substring(0, expression.length() - 1);
            }
            if (expression.contains("/")) {
                expression = "object";
            }
            if (this.syntax.containsKey(expression = String.valueOf(expression) + "0")) {
                while (this.syntax.containsKey(expression)) {
                    char lastChar = expression.charAt(expression.length() - 1);
                    if (lastChar < '0' || lastChar > '9') continue;
                    expression = expression.replace(lastChar, '\u0000');
                    expression = String.valueOf(expression) + (lastChar + '\u0001');
                }
            }
            this.syntax.put(expression, i);
            ++i;
        }
        this.expressions = expressions;
    }

    public ExpressionData(Expression<?>[] expressions) {
        this.expressions = expressions;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    @Nullable
    public int size() {
        return this.syntax.size();
    }

    @Nullable
    public Expression<?> getRaw(String input) {
        return this.expressions[this.syntax.get(input)];
    }

    @Nullable
    public Expression<?> get(int index) {
        if (this.expressions[index] == null) {
            return null;
        }
        return this.expressions[index];
    }

    @Nullable
    public Expression<?>[] getExpressions() {
        return this.expressions;
    }

    @Nullable
    public Map<String, Integer> getExpressionsMap() {
        return this.syntax;
    }

    @Nullable
    public <T> Expression<?> getExpression(Class<T> type, int index) {
        return this.expressions[this.syntax.get(String.valueOf(type.getSimpleName().toLowerCase()) + index)];
    }

    @Nullable
    public Object getFirst(Event event) {
        return this.expressions != null && this.expressions.length > 0 ? this.expressions[0].getSingle(event) : null;
    }

    @Nullable
    public Object getAllOfFirst(Event event) {
        return this.expressions != null && this.expressions.length > 0 ? this.expressions[0].getArray(event) : null;
    }

    @Nullable
    public <T> T getSingle(Event event, Class<T> type, int index) {
        if (this.getExpression(type, index) == null) {
            return null;
        }
        return (T)(this.syntax.containsKey(String.valueOf(type.getSimpleName().toLowerCase()) + index) ? this.getExpression(type, index).getSingle(event) : null);
    }

    public <T> T getSingle(Event event, Class<T> type) {
        return this.getSingle(event, type, 0);
    }

    public Integer getInt(Event event, int index) {
        return this.getSingle(event, Number.class, index).intValue();
    }

    public Integer getInt(Event event) {
        return this.getInt(event, 0);
    }

    public <T> List<T> getList(Event event, Class<T> type) {
        return Arrays.asList(this.getAll(event, type));
    }

    public <T> List<T> getList(Event event, Class<T> type, int index) {
        return Arrays.asList(this.getAll(event, type, index));
    }

    @Nullable
    public <T> T[] getAll(Event event, Class<T> type, int index) {
        return this.syntax.containsKey(String.valueOf(type.getSimpleName().toLowerCase()) + index) ? this.getExpression(type, index).getArray(event) : null;
    }

    @Nullable
    public <T> T[] getAll(Event event, Class<T> type) {
        return this.syntax.containsKey(String.valueOf(type.getSimpleName().toLowerCase()) + 0) ? this.getExpression(type, 0).getArray(event) : null;
    }

    @Nullable
    public <T> int getSize(Event event, Class<T> type, int index) {
        return this.syntax.containsKey(String.valueOf(type.getSimpleName().toLowerCase()) + index) ? Integer.valueOf(this.getExpression(type, index).getArray(event).length) : null;
    }

    @Nullable
    public <T> int getSize(Event event, Class<T> type) {
        return this.syntax.containsKey(String.valueOf(type.getSimpleName().toLowerCase()) + 0) ? Integer.valueOf(this.getExpression(type, 0).getArray(event).length) : null;
    }

    @Nullable
    public <T> Map<Expression<?>, Object> getMap(Event event) {
        HashMap data = new HashMap();
        Arrays.asList(this.expressions).forEach(expression -> {
            Object object = data.put((Expression<?>)expression, expression.getSingle(event));
        });
        return data.isEmpty() ? null : data;
    }

    @Nullable
    public <T> Map<Expression<?>, Object[]> getAllMap(Event event) {
        HashMap data = new HashMap();
        Arrays.asList(this.expressions).forEach(expression -> {
            Object[] objectArray = data.put((Expression<?>)expression, expression.getArray(event));
        });
        return data.isEmpty() ? null : data;
    }

    @Nullable
    public <T> Map<Expression<?>, T[]> getAllMapOf(Event event, Class<T> ... types) {
        int i = 0;
        HashMap data = new HashMap();
        Class<T>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<T> type = classArray[n2];
            for (String string : this.syntax.keySet()) {
                if (!string.contains(type.getSimpleName().toLowerCase()) || this.getExpression(type, i) == null) continue;
                data.put(this.getExpression(type, i), this.getAll(event, type, i));
            }
            ++i;
            ++n2;
        }
        return data.isEmpty() ? null : data;
    }
}

