/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.elements.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.util.Timespan;
import java.util.HashSet;
import java.util.Set;
import me.limeglass.skungee.objects.SkungeePacket;
import me.limeglass.skungee.objects.SkungeePacketType;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.lang.SkungeePropertyExpression;
import me.limeglass.skungee.spigot.sockets.Sockets;
import me.limeglass.skungee.spigot.utils.Utils;
import me.limeglass.skungee.spigot.utils.annotations.Properties;
import me.limeglass.skungee.spigot.utils.annotations.PropertiesAddition;
import org.bukkit.event.Event;

@Name(value="RedisBungee last online")
@Description(value={"Returns the last known online time(s) of the defined RedisBungee player(s)."})
@Properties(value={"strings/players", "redis[( |-)]bungee[[ ]cord] last [known] login[s] [time[s]]", "{1}[(all [[of] the]|the)]"})
@PropertiesAddition(value="[(player|uuid)[s]]")
public class ExprRedisBungeePlayerLastOnline
extends SkungeePropertyExpression<Object, Object> {
    protected Object[] get(Event event, Object[] skungeePlayers) {
        if (this.isNull(event).booleanValue()) {
            return null;
        }
        Set logins = (Set)Sockets.send(new SkungeePacket((Boolean)true, SkungeePacketType.REDISLASTLOGIN, Utils.toSkungeePlayers(skungeePlayers)));
        if (Skungee.getInstance().getConfig().getBoolean("Timespans", true)) {
            HashSet<Timespan> timespans = new HashSet<Timespan>();
            for (Number milliseconds : logins) {
                timespans.add(new Timespan(((Long)milliseconds).longValue()));
            }
            return timespans != null ? timespans.toArray(new Timespan[timespans.size()]) : null;
        }
        return logins != null ? logins.toArray(new Number[logins.size()]) : null;
    }
}

