/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import me.limeglass.skungee.EncryptionUtil;
import me.limeglass.skungee.objects.SkungeePacket;
import me.limeglass.skungee.objects.SkungeePacketType;
import me.limeglass.skungee.spigot.Metrics;
import me.limeglass.skungee.spigot.elements.Register;
import me.limeglass.skungee.spigot.sockets.PacketQueue;
import me.limeglass.skungee.spigot.sockets.Reciever;
import me.limeglass.skungee.spigot.sockets.Sockets;
import me.limeglass.skungee.spigot.test.TestListener;
import me.limeglass.skungee.spigot.utils.ReflectionUtil;
import me.limeglass.skungee.spigot.utils.Utils;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class Skungee
extends JavaPlugin {
    private static Map<String, FileConfiguration> files = new HashMap<String, FileConfiguration>();
    private static String packageName = "me.limeglass.skungee.spigot";
    private static String prefix = "&8[&cSkungee&8] &e";
    private static String nameplate = "[Skungee] ";
    private static EncryptionUtil encryption;
    private static SkriptAddon addonInstance;
    private static Skungee instance;
    private Metrics metrics;

    public void onEnable() {
        addonInstance = Skript.registerAddon((JavaPlugin)this).setLanguageFileDirectory("lang");
        instance = this;
        this.saveDefaultConfig();
        File config = new File(this.getDataFolder(), "config.yml");
        this.getServer().getPluginManager().registerEvents((Listener)new TestListener(), (Plugin)this);
        if (!Objects.equals(this.getDescription().getVersion(), this.getConfig().getString("version"))) {
            Skungee.consoleMessage("&dNew update found! Updating files now...");
            if (config.exists()) {
                config.delete();
            }
        }
        for (String name : Arrays.asList("config", "syntax")) {
            File file = new File(this.getDataFolder(), String.valueOf(name) + ".yml");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                this.saveResource(file.getName(), false);
            }
            YamlConfiguration configuration = new YamlConfiguration();
            try {
                configuration.load(file);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
            files.put(name, (FileConfiguration)configuration);
        }
        encryption = new EncryptionUtil(this, (Boolean)true);
        encryption.hashFile();
        if (this.getConfig().getBoolean("Queue.enabled", true)) {
            PacketQueue.start();
        }
        this.metrics = new Metrics(this);
        Register.metrics(this.metrics);
        if (this.getConfig().getBoolean("Reciever.enabled", false)) {
            Reciever.setupReciever();
        } else {
            Sockets.connect();
        }
        if (!this.getConfig().getBoolean("DisableRegisteredInfo", false)) {
            Bukkit.getLogger().info(String.valueOf(nameplate) + "has been enabled!");
        }
    }

    public void onDisable() {
        Sockets.send(new SkungeePacket((Boolean)false, SkungeePacketType.DISCONNECT, Bukkit.getPort()));
        Sockets.onPluginDisabling();
        PacketQueue.stop();
    }

    public static final void exception(Throwable cause, String ... info) {
        HashMap<String, PluginDescriptionFile> plugins = new HashMap<String, PluginDescriptionFile>();
        Plugin[] pluginArray = Bukkit.getPluginManager().getPlugins();
        int n = pluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            Plugin plugin = pluginArray[n2];
            if (!plugin.getDescription().getName().equals("Skungee")) {
                String[] parts = plugin.getDescription().getMain().split("\\.");
                StringBuilder name = new StringBuilder(plugin.getDescription().getMain().length());
                int i = 0;
                while (i < parts.length - 1) {
                    name.append(parts[i]).append('.');
                    ++i;
                }
                plugins.put(name.toString(), plugin.getDescription());
            }
            ++n2;
        }
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage(String.valueOf(Skungee.getNameplate()) + "Severe Error:");
        Skungee.infoMessage(info);
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Something went wrong within Skungee.");
        Skungee.infoMessage("Please report this error to the developers of Skungee so we can fix this from happening in the future.");
        HashSet<PluginDescriptionFile> stackPlugins = new HashSet<PluginDescriptionFile>();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n3 = stackTraceElementArray.length;
        n = 0;
        while (n < n3) {
            StackTraceElement stackTrace = stackTraceElementArray[n];
            for (Map.Entry entry : plugins.entrySet()) {
                if (!stackTrace.getClassName().contains((CharSequence)entry.getKey())) continue;
                stackPlugins.add((PluginDescriptionFile)entry.getValue());
            }
            ++n;
        }
        if (!stackPlugins.isEmpty()) {
            Skungee.infoMessage(new String[0]);
            Skungee.infoMessage("It looks like you are using some plugin(s) that aren't allowing Skungee to work properly.");
            Skungee.infoMessage("Following plugins are probably related to this error in some way:");
            StringBuilder pluginsMessage = new StringBuilder();
            for (PluginDescriptionFile desc : stackPlugins) {
                pluginsMessage.append(desc.getName());
                pluginsMessage.append(" ");
            }
            Skungee.infoMessage(pluginsMessage.toString());
            Skungee.infoMessage("You should try disabling those plugins one by one, trying to find which one causes it.");
            Skungee.infoMessage("If the error doesn't disappear even after disabling all listed plugins, it is probably a Skungee issue.");
        }
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Please report this on the Skungee discussion page on SkUnity or Spigot", "You can also message one of the Skungee developers this error.");
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Stack trace:");
        boolean first = true;
        while (cause != null) {
            Skungee.infoMessage(String.valueOf(first ? "" : "Caused by: ") + cause.toString());
            StackTraceElement[] stackTraceElementArray2 = cause.getStackTrace();
            int n4 = stackTraceElementArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                StackTraceElement e = stackTraceElementArray2[n5];
                Skungee.infoMessage("    at " + e.toString());
                ++n5;
            }
            cause = cause.getCause();
            first = false;
        }
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Information:");
        Skungee.infoMessage("  Skungee: " + Skungee.getInstance().getConfig().getString("version"));
        Skungee.infoMessage("  Bukkit: " + Bukkit.getBukkitVersion());
        Skungee.infoMessage("  Minecraft: " + ReflectionUtil.getVersion());
        Skungee.infoMessage("  Java: " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + ")");
        Skungee.infoMessage("  OS: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Running CraftBukkit: " + Skript.isRunningCraftBukkit());
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Thread: " + Thread.currentThread());
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("End of Error.");
        Skungee.infoMessage(new String[0]);
    }

    public static Skungee getInstance() {
        return instance;
    }

    public static EncryptionUtil getEncrypter() {
        return encryption;
    }

    public SkriptAddon getAddonInstance() {
        return addonInstance;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public static String getPackageName() {
        return packageName;
    }

    public static String getNameplate() {
        return nameplate;
    }

    public static String getPrefix() {
        return prefix;
    }

    public static FileConfiguration getConfiguration(String file) {
        return files.containsKey(file) ? files.get(file) : null;
    }

    public static void save(String configuration) {
        try {
            File configurationFile = new File(instance.getDataFolder(), String.valueOf(configuration) + ".yml");
            Skungee.getConfiguration(configuration).save(configurationFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void debugMessage(String ... messages) {
        if (instance.getConfig().getBoolean("debug")) {
            String[] stringArray = messages;
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                String text = stringArray[n2];
                Skungee.consoleMessage("&b" + text);
                ++n2;
            }
        }
    }

    public static void infoMessage(String ... messages) {
        if (messages != null && messages.length > 0) {
            String[] stringArray = messages;
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                String text = stringArray[n2];
                Bukkit.getLogger().info(String.valueOf(Skungee.getNameplate()) + text);
                ++n2;
            }
        } else {
            Bukkit.getLogger().info("");
        }
    }

    public static void consoleMessage(String ... messages) {
        if (instance.getConfig().getBoolean("DisableConsoleMessages", false)) {
            return;
        }
        if (messages != null && messages.length > 0) {
            String[] stringArray = messages;
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                String text = stringArray[n2];
                if (instance.getConfig().getBoolean("DisableConsoleColour", false)) {
                    Skungee.infoMessage(ChatColor.stripColor((String)Utils.cc(text)));
                } else {
                    Bukkit.getConsoleSender().sendMessage(Utils.cc(String.valueOf(prefix) + text));
                }
                ++n2;
            }
        } else {
            Bukkit.getLogger().info("");
        }
    }
}

