/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.sockets;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import me.limeglass.skungee.bungeecord.Skungee;
import me.limeglass.skungee.bungeecord.sockets.BungeeSockets;
import me.limeglass.skungee.objects.BungeePacket;
import me.limeglass.skungee.objects.BungeePacketType;
import me.limeglass.skungee.objects.ConnectedServer;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Plugin;

public class ServerTracker {
    private static Set<ConnectedServer> servers = new HashSet<ConnectedServer>();
    private static Set<ConnectedServer> notRespondingServers = new HashSet<ConnectedServer>();
    private static Map<ConnectedServer, Long> tracker = new HashMap<ConnectedServer, Long>();

    public static void tracker() {
        ProxyServer.getInstance().getScheduler().schedule((Plugin)Skungee.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (!servers.isEmpty()) {
                    for (ConnectedServer server : servers) {
                        if (tracker.containsKey(server)) {
                            long trys = Skungee.getConfig().getLong("Tracker.allowedTrys", 4L);
                            long lastupdated = (Long)tracker.get(server) + trys * (long)server.getHeartbeat().intValue();
                            if (lastupdated >= System.currentTimeMillis() || notRespondingServers.contains(server)) continue;
                            ServerTracker.notResponding(server);
                            continue;
                        }
                        tracker.put(server, System.currentTimeMillis() + (long)(5 * server.getHeartbeat()));
                    }
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public static void notResponding(ConnectedServer server) {
        if (server == null) {
            return;
        }
        Skungee.debugMessage("Server " + server.getName() + " has stopped responding!");
        if (Skungee.getConfig().getBoolean("Tracker.DisableTracking", false)) {
            ServerTracker.remove(server);
        } else {
            notRespondingServers.add(server);
        }
    }

    public static void dump() {
        tracker.clear();
        servers.clear();
        notRespondingServers.clear();
    }

    public static Boolean update(String string) {
        if (ServerTracker.get(string) == null) {
            return true;
        }
        ConnectedServer server = ServerTracker.get(string)[0];
        if (server != null) {
            tracker.put(server, System.currentTimeMillis());
            if (notRespondingServers.contains(server)) {
                notRespondingServers.remove(server);
                Skungee.debugMessage(String.valueOf(server.getName()) + " started responding again!");
            }
            ServerTracker.globalScripts(server);
            return false;
        }
        return true;
    }

    public static void globalScripts(ConnectedServer server) {
        if (Skungee.getConfig().getBoolean("GlobalScripts.Enabled", true) && Skungee.getScriptsFolder().listFiles().length > 0) {
            HashMap<String, List<String>> data = new HashMap<String, List<String>>();
            File[] fileArray = Skungee.getScriptsFolder().listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File script = fileArray[n2];
                try {
                    data.put(script.getName(), Files.readAllLines(script.toPath(), Charset.defaultCharset()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            BungeeSockets.send(server, new BungeePacket((Boolean)false, BungeePacketType.GLOBALSCRIPTS, data));
        }
    }

    public static ConnectedServer[] get(String name) {
        if (ServerTracker.isEmpty().booleanValue()) {
            return null;
        }
        for (ConnectedServer server : servers) {
            if (!server.getName().equalsIgnoreCase(name)) continue;
            return new ConnectedServer[]{server};
        }
        if (name.contains(":")) {
            String[] addresses;
            String[] stringArray;
            HashSet<ConnectedServer> connectedservers = new HashSet<ConnectedServer>();
            if (name.contains(",")) {
                stringArray = name.split(",");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = name;
            }
            String[] stringArray3 = addresses = stringArray;
            int n = addresses.length;
            int n2 = 0;
            while (n2 < n) {
                String address = stringArray3[n2];
                if (!address.contains(":")) {
                    ConnectedServer possiblyNamed = ServerTracker.get(address)[0];
                    if (possiblyNamed == null) {
                        connectedservers.add(possiblyNamed);
                    }
                } else {
                    Object[] ipPort = address.split(":");
                    try {
                        for (ConnectedServer server : servers) {
                            if (!server.getAddress().equals(InetAddress.getByName((String)ipPort[0])) || server.getPort() != Integer.parseInt((String)ipPort[1])) continue;
                            connectedservers.add(server);
                        }
                    }
                    catch (UnknownHostException e) {
                        Skungee.consoleMessage("There was no server found with the address: " + Arrays.toString(ipPort));
                    }
                }
                ++n2;
            }
            if (connectedservers != null) {
                return connectedservers.toArray(new ConnectedServer[connectedservers.size()]);
            }
        }
        return null;
    }

    public static ConnectedServer getByAddress(InetAddress address, int serverPort) {
        if (ServerTracker.isEmpty().booleanValue()) {
            return null;
        }
        for (ConnectedServer server : servers) {
            if (!server.getAddress().equals(address) || server.getPort() != serverPort) continue;
            return server;
        }
        return null;
    }

    public static Boolean isEmpty() {
        return servers.isEmpty();
    }

    public static Set<ConnectedServer> getAll() {
        return servers;
    }

    public static Boolean contains(ConnectedServer server) {
        return servers.contains(server);
    }

    public static Boolean isResponding(ConnectedServer server) {
        return !notRespondingServers.contains(server);
    }

    public static void add(ConnectedServer server) {
        HashSet<ConnectedServer> toRemove = new HashSet<ConnectedServer>();
        for (ConnectedServer connected : servers) {
            if (!connected.getAddress().equals(server.getAddress()) || !connected.getPort().equals(server.getPort())) continue;
            toRemove.add(connected);
        }
        for (ConnectedServer connected : toRemove) {
            ServerTracker.remove(connected);
        }
        servers.add(server);
        Skungee.consoleMessage("Connected to server " + server.getName() + " with port " + server.getPort());
    }

    public static void remove(ConnectedServer server) {
        tracker.remove(server);
        notRespondingServers.remove(server);
        servers.remove(server);
    }
}

