/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.limeglass.skungee.EncryptionUtil;
import me.limeglass.skungee.UniversalSkungee;
import me.limeglass.skungee.bungeecord.BungecordMetrics;
import me.limeglass.skungee.bungeecord.VariableStorage;
import me.limeglass.skungee.bungeecord.listeners.EventListener;
import me.limeglass.skungee.bungeecord.sockets.SocketRunnable;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginDescription;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class Skungee
extends Plugin {
    private static final String prefix = "&8[&cSkungee&8] &e";
    private static final String nameplate = "[Skungee] ";
    private static EncryptionUtil encryption;
    private static BungecordMetrics metrics;
    private static Configuration config;
    private static File SCRIPTS_FOLDER;
    private ServerSocket serverSocket;
    private static Skungee instance;
    private static File configFile;

    public void onEnable() {
        InputStream in;
        Object var3_8;
        instance = this;
        UniversalSkungee.setBungeecord(true);
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        if (!(SCRIPTS_FOLDER = new File(this.getDataFolder(), String.valueOf(File.separator) + "scripts")).exists()) {
            SCRIPTS_FOLDER.mkdir();
        }
        Boolean newConfig = false;
        configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            try {
                Throwable throwable = null;
                var3_8 = null;
                try {
                    in = this.getResourceAsStream("Bungeecord/config.yml");
                    try {
                        newConfig = true;
                        Files.copy(in, configFile.toPath(), new CopyOption[0]);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Skungee.exception(e, "could not create config.");
            }
        }
        try {
            config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(configFile);
        }
        catch (IOException e) {
            Skungee.exception(e, "could not save config.");
        }
        if (newConfig.booleanValue()) {
            Skungee.consoleMessage("&cNo config was found, generating a new config...");
        }
        if (!this.getDescription().getVersion().equals(config.getString("version"))) {
            Skungee.consoleMessage("&eThere is a new Skungee version. Generating new config...");
            try {
                Throwable e = null;
                var3_8 = null;
                try {
                    in = this.getResourceAsStream("Bungeecord/config.yml");
                    try {
                        Files.delete(configFile.toPath());
                        Files.copy(in, configFile.toPath(), new CopyOption[0]);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                Skungee.exception(e, "could not create and save config due to new version.");
            }
        }
        encryption = new EncryptionUtil(this, (Boolean)false);
        encryption.hashFile();
        metrics = new BungecordMetrics(this);
        metrics.addCustomChart(new BungecordMetrics.SimplePie("amount_of_plugins"){

            @Override
            public String getValue() {
                return String.valueOf(Skungee.this.getProxy().getPluginManager().getPlugins().size());
            }
        });
        metrics.addCustomChart(new BungecordMetrics.SingleLineChart("amount_of_global_scripts"){

            @Override
            public int getValue() {
                return SCRIPTS_FOLDER.listFiles().length;
            }
        });
        if (config.getBoolean("Events", false)) {
            this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new EventListener());
        }
        this.connect();
        VariableStorage.setup();
        if (!config.getBoolean("DisableRegisteredInfo", false)) {
            Skungee.consoleMessage("has been enabled!");
        }
    }

    private void connect() {
        try {
            this.serverSocket = new ServerSocket(Skungee.getConfig().getInt("port", 1337), 69);
            Skungee.consoleMessage("connection established on port " + Skungee.getConfig().getInt("port", 1337));
            ProxyServer.getInstance().getScheduler().runAsync((Plugin)Skungee.getInstance(), new Runnable(){

                @Override
                public void run() {
                    while (!Skungee.this.serverSocket.isClosed()) {
                        try {
                            new Thread(new SocketRunnable(Skungee.this.serverSocket.accept())).start();
                        }
                        catch (IOException e) {
                            Skungee.exception(e, "Socket couldn't be accepted.");
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            Skungee.exception(e, "ServerSocket couldn't be created on port: " + Skungee.getConfig().getInt("port", 1337));
        }
    }

    public static final void exception(Throwable cause, String ... info) {
        HashMap<String, PluginDescription> plugins = new HashMap<String, PluginDescription>();
        for (Plugin plugin : ProxyServer.getInstance().getPluginManager().getPlugins()) {
            if (plugin.getDescription().getName().equals("Skungee")) continue;
            String[] parts = plugin.getDescription().getMain().split("\\.");
            StringBuilder name = new StringBuilder(plugin.getDescription().getMain().length());
            int i = 0;
            while (i < parts.length - 1) {
                name.append(parts[i]).append('.');
                ++i;
            }
            plugins.put(name.toString(), plugin.getDescription());
        }
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage(String.valueOf(Skungee.getNameplate()) + "Severe Error: " + info);
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Something went wrong within Skungee.");
        Skungee.infoMessage("Please report this error to the developers of Skungee so we can fix this from happening in the future.");
        Skungee.infoMessage(new String[0]);
        HashSet<PluginDescription> stackPlugins = new HashSet<PluginDescription>();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n = stackTraceElementArray.length;
        int parts = 0;
        while (parts < n) {
            StackTraceElement stackTrace = stackTraceElementArray[parts];
            for (Map.Entry entry : plugins.entrySet()) {
                if (!stackTrace.getClassName().contains((CharSequence)entry.getKey())) continue;
                stackPlugins.add((PluginDescription)entry.getValue());
            }
            ++parts;
        }
        if (!stackPlugins.isEmpty()) {
            Skungee.infoMessage("It looks like you are using some plugin(s) that aren't allowing Skungee to work properly.");
            Skungee.infoMessage("Following plugins are probably related to this error in some way:");
            StringBuilder pluginsMessage = new StringBuilder();
            for (PluginDescription desc : stackPlugins) {
                pluginsMessage.append(desc.getName());
                pluginsMessage.append(" ");
            }
            Skungee.infoMessage(pluginsMessage.toString());
            Skungee.infoMessage("You should try disabling those plugins one by one, trying to find which one causes it.");
            Skungee.infoMessage("If the error doesn't disappear even after disabling all listed plugins, it is probably a Skungee issue.");
        }
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Please report this on the Skungee discussion page on SkUnity or Spigot. You can also message one of the Skungee developers.");
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Stack trace:");
        boolean first = true;
        while (cause != null) {
            Skungee.infoMessage(String.valueOf(first ? "" : "Caused by: ") + cause.toString());
            StackTraceElement[] stackTraceElementArray2 = cause.getStackTrace();
            int n2 = stackTraceElementArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                StackTraceElement e = stackTraceElementArray2[n3];
                Skungee.infoMessage("    at " + e.toString());
                ++n3;
            }
            cause = cause.getCause();
            first = false;
        }
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Information:");
        Skungee.infoMessage("  Skungee: " + Skungee.getConfig().getString("version"));
        Skungee.infoMessage("  Bungee: " + ProxyServer.getInstance().getVersion());
        Skungee.infoMessage("  Game version: " + ProxyServer.getInstance().getGameVersion());
        Skungee.infoMessage("  Protocol version: " + ProxyServer.getInstance().getProtocolVersion());
        Skungee.infoMessage("  Java: " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + ")");
        Skungee.infoMessage("  OS: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Thread: " + Thread.currentThread());
        Skungee.infoMessage("Cause: " + info);
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("End of Error.");
        Skungee.infoMessage(new String[0]);
    }

    public static Skungee getInstance() {
        return instance;
    }

    public static Configuration getConfig() {
        return config;
    }

    public static BungecordMetrics getMetrics() {
        return metrics;
    }

    public static EncryptionUtil getEncrypter() {
        return encryption;
    }

    public static String getNameplate() {
        return nameplate;
    }

    public static String getPrefix() {
        return prefix;
    }

    public static File getScriptsFolder() {
        return SCRIPTS_FOLDER;
    }

    public static void debugMessage(String text) {
        if (config.getBoolean("debug")) {
            Skungee.consoleMessage("&b" + text);
        }
    }

    public static String cc(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static void infoMessage(String ... messages) {
        if (messages != null && messages.length > 0) {
            String[] stringArray = messages;
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                String text = stringArray[n2];
                ProxyServer.getInstance().getLogger().info(String.valueOf(Skungee.getNameplate()) + text);
                ++n2;
            }
        } else {
            ProxyServer.getInstance().getLogger().info("");
        }
    }

    public static void consoleMessage(String ... messages) {
        if (config.getBoolean("DisableConsoleMessages", false)) {
            return;
        }
        if (messages != null && messages.length > 0) {
            String[] stringArray = messages;
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                String text = stringArray[n2];
                if (config.getBoolean("DisableConsoleColour", false)) {
                    Skungee.infoMessage(ChatColor.stripColor((String)Skungee.cc(text)));
                } else {
                    ProxyServer.getInstance().getLogger().info(Skungee.cc(prefix + text));
                }
                ++n2;
            }
        } else {
            ProxyServer.getInstance().getLogger().info("");
        }
    }
}

