/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.sockets;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import me.limeglass.skungee.objects.BungeePacket;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.sockets.Sockets;
import me.limeglass.skungee.spigot.sockets.SpigotPacketHandler;
import org.bukkit.Bukkit;
import org.eclipse.jdt.annotation.Nullable;

public class SpigotRunnable
implements Runnable {
    private InetAddress address;
    private Socket socket;

    public SpigotRunnable(Socket socket) {
        this.socket = socket;
        this.address = socket.getInetAddress();
    }

    @Override
    public void run() {
        if (Skungee.getInstance().getConfig().getBoolean("security.breaches.enabled", false)) {
            List addresses = Skungee.getInstance().getConfig().getStringList("security.breaches.blacklisted");
            if (!Skungee.getInstance().getConfig().getBoolean("security.breaches.blacklist-is-whitelist", false) ? Sockets.blocked.contains(this.address) || addresses.contains(this.address.getHostName()) : !addresses.contains(this.address.getHostName())) {
                return;
            }
        }
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(this.socket.getInputStream());
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.socket.getOutputStream());
            Object object = objectInputStream.readObject();
            if (object != null) {
                Object packetData;
                BungeePacket packet;
                try {
                    if (Skungee.getInstance().getConfig().getBoolean("security.encryption.enabled", false)) {
                        byte[] decoded = Base64.getDecoder().decode((byte[])object);
                        packet = (BungeePacket)Skungee.getEncrypter().deserialize(decoded);
                    } else {
                        packet = (BungeePacket)object;
                    }
                }
                catch (ClassCastException e) {
                    Skungee.consoleMessage("", "Some security settings didn't match for the incoming packet.", "Make sure all your security options on the Spigot servers match the same as in the Bungeecord Skungee config.yml", "The packet could not be read, thus being cancelled.");
                    this.attempt(this.address, null);
                    return;
                }
                if (packet.getPassword() != null) {
                    if (Skungee.getInstance().getConfig().getBoolean("security.password.hash", true)) {
                        if (Skungee.getInstance().getConfig().getBoolean("security.password.hashFile", false) && Skungee.getEncrypter().isFileHashed().booleanValue()) {
                            if (!Arrays.equals(Skungee.getEncrypter().getHashFromFile(), packet.getPassword())) {
                                this.incorrectPassword(packet);
                                return;
                            }
                        } else if (!Arrays.equals(Skungee.getEncrypter().hash(), packet.getPassword())) {
                            this.incorrectPassword(packet);
                            return;
                        }
                    } else {
                        String password = (String)Skungee.getEncrypter().deserialize(packet.getPassword());
                        if (!password.equals(Skungee.getInstance().getConfig().getString("security.password.password"))) {
                            this.incorrectPassword(packet);
                            return;
                        }
                    }
                } else if (Skungee.getInstance().getConfig().getBoolean("security.password.enabled", false)) {
                    this.incorrectPassword(packet);
                    return;
                }
                if (Sockets.attempts.containsKey(this.address)) {
                    Sockets.attempts.remove(this.address);
                }
                if ((packetData = SpigotPacketHandler.handlePacket(packet, this.address)) != null) {
                    if (Skungee.getInstance().getConfig().getBoolean("security.encryption.enabled", false)) {
                        byte[] serialized = Skungee.getEncrypter().serialize(packetData);
                        objectOutputStream.writeObject(Base64.getEncoder().encode(serialized));
                    } else {
                        objectOutputStream.writeObject(packetData);
                    }
                }
            }
            objectInputStream.close();
            objectOutputStream.close();
        }
        catch (IOException | ClassNotFoundException objectInputStream) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void incorrectPassword(BungeePacket packet) {
        this.attempt(this.address, packet);
        Skungee.consoleMessage("&cA BungeePacket with an incorrect password has just been recieved and blocked!");
        Skungee.consoleMessage("&cThe packet came from: " + this.socket.getInetAddress());
        Skungee.consoleMessage("&cThe packet type was: " + (Object)((Object)packet.getType()));
    }

    private void attempt(InetAddress address, @Nullable BungeePacket packet) {
        if (Skungee.getInstance().getConfig().getBoolean("security.breaches.enabled", false)) {
            int attempts = 0;
            if (Sockets.attempts.containsKey(address)) {
                attempts = Sockets.attempts.get(address);
                Sockets.attempts.remove(address, attempts);
            }
            Sockets.attempts.put(address, ++attempts);
            if (attempts >= Skungee.getInstance().getConfig().getInt("security.breaches.attempts", 30)) {
                if (Skungee.getInstance().getConfig().getBoolean("security.breaches.log", false)) {
                    this.log("", "&cA BungeePacket with an incorrect password has just been recieved and blocked!", "&cThe packet came from: " + this.socket.getInetAddress());
                    if (packet != null) {
                        this.log("&cThe packet type was: " + (Object)((Object)packet.getType()));
                    }
                }
                if (Skungee.getInstance().getConfig().getBoolean("security.breaches.shutdown", false)) {
                    Bukkit.shutdown();
                }
                if (Skungee.getInstance().getConfig().getBoolean("security.breaches.blockAddress", false) && !Sockets.blocked.contains(address)) {
                    Sockets.blocked.add(address);
                }
            }
        }
    }

    private void log(String ... strings) {
        try {
            Logger logger = Logger.getLogger("log");
            FileHandler handler = new FileHandler(Skungee.getInstance().getDataFolder() + File.separator + "breaches.log");
            handler.setFormatter(new SimpleFormatter());
            logger.addHandler(handler);
            String[] stringArray = strings;
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                logger.info(string);
                ++n2;
            }
        }
        catch (IOException | SecurityException e) {
            Skungee.exception(e, "Error logging a breach.");
        }
    }
}

