/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.sockets;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.limeglass.skungee.EncryptionUtil;
import me.limeglass.skungee.UniversalSkungee;
import me.limeglass.skungee.objects.SkungeePacket;
import me.limeglass.skungee.objects.SkungeePacketType;
import me.limeglass.skungee.objects.SkungeePlayer;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.sockets.PacketQueue;
import me.limeglass.skungee.spigot.sockets.Reciever;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class Sockets {
    public static Map<InetAddress, Integer> attempts = new HashMap<InetAddress, Integer>();
    public static Set<InetAddress> blocked = new HashSet<InetAddress>();
    public static Socket bungeecord;
    private static Boolean restart;
    private static Boolean checking;
    private static int task;
    private static int heartbeat;
    private static int keepAlive;
    public static Long lastSent;

    static {
        restart = true;
        checking = false;
        lastSent = System.currentTimeMillis();
    }

    private static void startHeartbeat() {
        task = Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)Skungee.getInstance(), new Runnable(){

            @Override
            public void run() {
                Boolean answer = (Boolean)Sockets.send(new SkungeePacket((Boolean)true, SkungeePacketType.HEARTBEAT, Bukkit.getPort()));
                if (answer != null && answer.booleanValue()) {
                    Sockets.stop(true);
                }
            }
        }, 1L, (long)Skungee.getInstance().getConfig().getInt("heartbeat", 30));
    }

    private static void keepAlive() {
        restart = true;
        keepAlive = Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)Skungee.getInstance(), new Runnable(){

            @Override
            public void run() {
                try {
                    new Socket(Skungee.getInstance().getConfig().getString("host", "0.0.0.0"), Skungee.getInstance().getConfig().getInt("port", 1337));
                    Bukkit.getScheduler().cancelTask(keepAlive);
                    Skungee.consoleMessage("Connection established again!");
                    Sockets.connect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, 1L, (long)(Skungee.getInstance().getConfig().getInt("keepAlive", 10) * 20));
    }

    public static void connect() {
        HashSet<SkungeePlayer> whitelisted = new HashSet<SkungeePlayer>();
        for (OfflinePlayer player : Bukkit.getWhitelistedPlayers()) {
            whitelisted.add(new SkungeePlayer(true, player.getUniqueId(), player.getName()));
        }
        FileConfiguration config = Skungee.getInstance().getConfig();
        if (config == null) {
            Skungee.consoleMessage("The configuration was null, try restarting the server and closing any configuration files that you may have open");
        }
        final ArrayList<Object> data = new ArrayList<Object>(Arrays.asList(Skungee.getInstance().getConfig().getBoolean("Reciever.enabled", false), Reciever.getReciever().getLocalPort(), Bukkit.getPort(), whitelisted, Skungee.getInstance().getConfig().getInt("heartbeat", 30) * 60, Bukkit.getMotd(), Bukkit.getMaxPlayers()));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Skungee.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (Sockets.getSocketConnection() == null) {
                    Sockets.stop(false);
                    restart = true;
                } else {
                    int i = 0;
                    while (i < 10) {
                        String state = (String)Sockets.send(new SkungeePacket((Boolean)true, SkungeePacketType.PING, data));
                        if (state != null && state.equals("CONNECTED")) break;
                        ++i;
                    }
                    Sockets.startHeartbeat();
                }
            }
        });
    }

    private static Socket getSocketConnection() {
        int i = 0;
        while (i < Skungee.getInstance().getConfig().getInt("maxAttempts", 20)) {
            try {
                return new Socket(Skungee.getInstance().getConfig().getString("host", "0.0.0.0"), Skungee.getInstance().getConfig().getInt("port", 1337));
            }
            catch (IOException iOException) {
                ++i;
            }
        }
        Skungee.consoleMessage("Could not establish connection to Skungee on the Bungeecord!");
        return null;
    }

    public static Object send(final SkungeePacket packet) {
        if (packet.isReturnable().booleanValue()) {
            return Sockets.send_i(packet);
        }
        if (Skungee.getInstance().getConfig().getBoolean("Queue.enabled", true)) {
            PacketQueue.queue(packet);
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Skungee.getInstance(), new Runnable(){

                @Override
                public void run() {
                    Sockets.send_i(packet);
                }
            });
        }
        return null;
    }

    public static Object send_i(SkungeePacket packet) {
        try {
            if (!checking.booleanValue()) {
                checking = true;
                bungeecord = Sockets.getSocketConnection();
                checking = false;
                if (bungeecord == null) {
                    Bukkit.getScheduler().cancelTask(heartbeat);
                    Sockets.stop(restart);
                    restart = false;
                } else {
                    EncryptionUtil encrypter = new EncryptionUtil(Skungee.getInstance(), (Boolean)true);
                    if (!Skungee.getInstance().getConfig().getBoolean("IgnoreSpamPackets", true)) {
                        Skungee.debugMessage("Sending " + UniversalSkungee.getPacketDebug(packet));
                    } else if (packet.getType() != SkungeePacketType.HEARTBEAT) {
                        Skungee.debugMessage("Sending " + UniversalSkungee.getPacketDebug(packet));
                    }
                    if (Skungee.getInstance().getConfig().getBoolean("security.password.enabled", false)) {
                        byte[] password = encrypter.serialize(Skungee.getInstance().getConfig().getString("security.password.password"));
                        if (Skungee.getInstance().getConfig().getBoolean("security.password.hash", true)) {
                            password = Skungee.getInstance().getConfig().getBoolean("security.password.hashFile", false) && encrypter.isFileHashed() != false ? encrypter.getHashFromFile() : encrypter.hash();
                        }
                        if (password != null) {
                            packet.setPassword(password);
                        }
                    }
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(bungeecord.getOutputStream());
                    if (Skungee.getInstance().getConfig().getBoolean("security.encryption.enabled", false)) {
                        byte[] serialized = encrypter.serialize(packet);
                        objectOutputStream.writeObject(Base64.getEncoder().encode(serialized));
                    } else {
                        objectOutputStream.writeObject(packet);
                    }
                    lastSent = System.currentTimeMillis();
                    ObjectInputStream objectInputStream = new ObjectInputStream(bungeecord.getInputStream());
                    bungeecord.setSoTimeout(10000);
                    if (packet.isReturnable().booleanValue()) {
                        if (Skungee.getInstance().getConfig().getBoolean("security.encryption.enabled", false)) {
                            byte[] decoded = Base64.getDecoder().decode((byte[])objectInputStream.readObject());
                            return encrypter.deserialize(decoded);
                        }
                        return objectInputStream.readObject();
                    }
                    objectOutputStream.close();
                    objectInputStream.close();
                    bungeecord.close();
                }
            }
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
        return null;
    }

    public static void onPluginDisabling() {
        Bukkit.getScheduler().cancelTask(task);
        Bukkit.getScheduler().cancelTask(heartbeat);
        Bukkit.getScheduler().cancelTask(keepAlive);
        if (bungeecord != null) {
            try {
                bungeecord.close();
            }
            catch (IOException e) {
                Skungee.exception(e, "&cError closing main socket.");
            }
        }
    }

    public static void stop(Boolean reconnect) {
        Bukkit.getScheduler().cancelTask(task);
        Bukkit.getScheduler().cancelTask(heartbeat);
        Bukkit.getScheduler().cancelTask(keepAlive);
        if (bungeecord != null) {
            try {
                bungeecord.close();
            }
            catch (IOException e) {
                Skungee.exception(e, "&cError closing main socket.");
            }
        }
        if (reconnect.booleanValue()) {
            Skungee.consoleMessage("&6Attempting to reconnect to Skungee...");
            Sockets.connect();
        } else if (Skungee.getInstance().getConfig().getBoolean("reconnect", false)) {
            Skungee.consoleMessage("&6Going into keep alive mode...");
            Sockets.keepAlive();
        } else {
            Skungee.consoleMessage("&cDisconnected from Skungee!");
            Skungee.consoleMessage("Could be incorrect Skungee details, there was no socket found or was denied access. For socket at " + Skungee.getInstance().getConfig().getString("host", "0.0.0.0") + ":" + Skungee.getInstance().getConfig().getInt("port", 1337));
        }
    }
}

