/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.database;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import me.limeglass.skungee.bungeecord.database.Serializer;
import me.limeglass.skungee.bungeecord.database.serializers.PlayerTimeSerializer;
import me.limeglass.skungee.bungeecord.managers.PlayerTimeManager;

public abstract class Database<T> {
    protected final Gson gson;
    private final GsonBuilder builder = new GsonBuilder().registerTypeAdapter(PlayerTimeManager.PlayerTime.class, (Object)new PlayerTimeSerializer()).excludeFieldsWithModifiers(new int[]{128, 8}).enableComplexMapKeySerialization().serializeNulls();

    public Database(Map<Type, Serializer<?>> serializers) {
        serializers.forEach((type, serializer) -> this.builder.registerTypeAdapter(type, serializer));
        this.gson = this.builder.create();
    }

    public Database() {
        this.gson = this.builder.create();
    }

    public abstract void put(String var1, T var2);

    public abstract T get(String var1, T var2);

    public abstract boolean has(String var1);

    public abstract Set<String> getKeys();

    public T get(String key) {
        return this.get(key, null);
    }

    public void delete(String key) {
        this.put(key, null);
    }

    public abstract void clear();

    public String serialize(Object object, Type type) {
        return this.gson.toJson(object, type);
    }

    public Object deserialize(String json, Type type) {
        return this.gson.fromJson(json, type);
    }
}

