/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.sockets;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import me.limeglass.skungee.EncryptionUtil;
import me.limeglass.skungee.UniversalSkungee;
import me.limeglass.skungee.objects.events.SkungeeReceivedEvent;
import me.limeglass.skungee.objects.events.SkungeeReturningEvent;
import me.limeglass.skungee.objects.packets.BungeePacket;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.sockets.SpigotPacketHandler;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class SpigotRunnable
implements Runnable {
    private final Map<InetAddress, Integer> attempts = new HashMap<InetAddress, Integer>();
    private final Set<InetAddress> blocked = new HashSet<InetAddress>();
    private final FileConfiguration configuration = Skungee.getInstance().getConfig();
    private InetAddress address;
    private Socket socket;

    public SpigotRunnable(Socket socket) {
        this.address = socket.getInetAddress();
        this.socket = socket;
    }

    @Override
    public void run() {
        block24: {
            if (this.configuration.getBoolean("security.breaches.enabled", false)) {
                List addresses = this.configuration.getStringList("security.breaches.blacklisted");
                if (this.blocked.contains(this.address) || addresses.contains(this.address.getHostName())) {
                    return;
                }
            }
            try {
                String algorithm = this.configuration.getString("security.encryption.cipherAlgorithm", "AES/CBC/PKCS5Padding");
                String keyString = this.configuration.getString("security.encryption.cipherKey", "insert 16 length");
                ObjectInputStream objectInputStream = new ObjectInputStream(this.socket.getInputStream());
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.socket.getOutputStream());
                EncryptionUtil encryption = Skungee.getInstance().getEncrypter();
                Object object = objectInputStream.readObject();
                if (object != null) {
                    Object packetData;
                    BungeePacket packet = null;
                    try {
                        packet = this.configuration.getBoolean("security.encryption.enabled", false) ? (BungeePacket)encryption.decrypt(keyString, algorithm, (byte[])object) : (BungeePacket)object;
                    }
                    catch (ClassCastException e) {
                        Skungee.consoleMessage("", "Some security settings didn't match for the incoming packet.", "Make sure all your security options on the Spigot servers match the same as in the Bungeecord Skungee configuration.yml", "The packet could not be read, thus being cancelled.");
                        if (this.configuration.getBoolean("security.debug")) {
                            Skungee.exception(e, "Could not decrypt packet " + UniversalSkungee.getPacketDebug(packet));
                        }
                        this.attempt(this.address, null);
                        return;
                    }
                    SkungeeReceivedEvent event = new SkungeeReceivedEvent(packet);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                    if (packet.getPassword() != null) {
                        Object password;
                        if (this.configuration.getBoolean("security.password.hash", true)) {
                            password = encryption.hash();
                            if (this.configuration.getBoolean("security.password.hashFile", false) && encryption.isFileHashed().booleanValue()) {
                                password = encryption.getHashFromFile();
                            }
                            if (!Arrays.equals(password, packet.getPassword())) {
                                this.incorrectPassword(packet);
                                return;
                            }
                        } else {
                            password = (String)encryption.deserialize(packet.getPassword());
                            if (!password.equals(this.configuration.getString("security.password.password"))) {
                                this.incorrectPassword(packet);
                                return;
                            }
                        }
                    } else if (this.configuration.getBoolean("security.password.enabled", false)) {
                        this.incorrectPassword(packet);
                        return;
                    }
                    if (this.attempts.containsKey(this.address)) {
                        this.attempts.remove(this.address);
                    }
                    if ((packetData = SpigotPacketHandler.handlePacket(packet, this.address)) != null) {
                        SkungeeReturningEvent returning = new SkungeeReturningEvent(packet, packetData);
                        Bukkit.getPluginManager().callEvent((Event)returning);
                        if (returning.isCancelled()) {
                            return;
                        }
                        packetData = returning.getObject();
                        if (this.configuration.getBoolean("security.encryption.enabled", false)) {
                            byte[] serialized = encryption.serialize(packetData);
                            byte[] encrypted = encryption.encrypt(keyString, algorithm, serialized);
                            objectOutputStream.writeObject(encrypted);
                        } else {
                            objectOutputStream.writeObject(packetData);
                        }
                    }
                }
                objectInputStream.close();
                objectOutputStream.close();
            }
            catch (IOException | ClassNotFoundException e) {
                if (!this.configuration.getBoolean("security.debug")) break block24;
                Skungee.exception(e, "Could not read incoming packet");
            }
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void incorrectPassword(BungeePacket packet) {
        this.attempt(this.address, packet);
        Skungee.consoleMessage("&cA BungeePacket with an incorrect password has just been recieved and blocked!");
        Skungee.consoleMessage("&cThe packet came from: " + this.socket.getInetAddress());
        Skungee.consoleMessage("&cThe packet type was: " + (Object)((Object)packet.getType()));
    }

    private void attempt(InetAddress address, @Nullable BungeePacket packet) {
        if (!this.configuration.getBoolean("security.breaches.enabled", false)) {
            return;
        }
        int i = 0;
        if (this.attempts.containsKey(address)) {
            i = this.attempts.get(address);
        }
        this.attempts.put(address, ++i);
        if (i >= this.configuration.getInt("security.breaches.attempts", 30)) {
            if (this.configuration.getBoolean("security.breaches.log", false)) {
                this.log("", "&cA BungeePacket with an incorrect password has just been recieved and blocked!", "&cThe packet came from: " + this.socket.getInetAddress());
                if (packet != null) {
                    this.log("&cThe packet type was: " + (Object)((Object)packet.getType()));
                }
            }
            if (this.configuration.getBoolean("security.breaches.shutdown", false)) {
                Bukkit.shutdown();
            }
            if (this.configuration.getBoolean("security.breaches.blockAddress", false) && !this.blocked.contains(address)) {
                this.blocked.add(address);
            }
        }
    }

    private void log(String ... strings) {
        try {
            Logger logger = Logger.getLogger("log");
            FileHandler handler = new FileHandler(Skungee.getInstance().getDataFolder() + File.separator + "breaches.log");
            handler.setFormatter(new SimpleFormatter());
            logger.addHandler(handler);
            for (String string : strings) {
                logger.info(string);
            }
        }
        catch (IOException | SecurityException e) {
            Skungee.exception(e, "Error logging a breach.");
        }
    }
}

