/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.StringMode;
import ch.njol.util.Kleenean;
import java.util.HashSet;
import me.limeglass.skungee.objects.SkungeeVariable;
import me.limeglass.skungee.objects.packets.SkungeePacket;
import me.limeglass.skungee.objects.packets.SkungeePacketType;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.lang.SkungeeEffect;
import me.limeglass.skungee.spigot.utils.annotations.Patterns;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

@Name(value="Network variable Async")
@Description(value={"Sets a defined variable on the Spigot side in a async cache from the network variables on the Bungeecord Skungee."})
@Patterns(value={"set async [variable] %objects% to [the] [skungee] (global|network|bungee[[ ]cord]) variable [(from|of)] %objects%", "set [variable] %objects% in async to [the] [skungee] (global|network|bungee[[ ]cord]) variable [(from|of)] %objects%"})
public class EffAsyncNetworkVariable
extends SkungeeEffect {
    private VariableString variableString;
    private static Variable<?> variable;

    private <T> Expression<T> getExpression(Expression<?> expr) {
        if (expr instanceof UnparsedLiteral) {
            Literal parsedLiteral = ((UnparsedLiteral)expr).getConvertedExpression(new Class[]{Object.class});
            return parsedLiteral == null ? expr : parsedLiteral;
        }
        return expr;
    }

    @Override
    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        Expression expression;
        Variable network = null;
        if (expressions[0] instanceof Variable) {
            variable = (Variable)expressions[0];
        } else {
            expression = this.getExpression(expressions[0]);
            if (expression instanceof Variable) {
                variable = (Variable)expression;
            }
        }
        if (expressions[1] instanceof Variable) {
            network = (Variable)expressions[1];
        } else {
            expression = this.getExpression(expressions[1]);
            if (expression instanceof Variable) {
                network = (Variable)expression;
            }
        }
        if (network != null) {
            if (network.isLocal()) {
                Skript.error((String)"Network Variables can not be a local variable.");
                return false;
            }
            String var = network.toString().substring(1, network.toString().length() - 1);
            this.variableString = VariableString.newInstance((String)var, (StringMode)StringMode.VARIABLE_NAME);
            return true;
        }
        Skript.error((String)"Network Variables must be in a variable format!");
        return false;
    }

    protected TriggerItem walk(Event event) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Skungee.getInstance(), () -> {
            Object object = this.sockets.send(new SkungeePacket(true, SkungeePacketType.NETWORKVARIABLE, (Object)this.variableString.toString(event)));
            if (object == null) {
                return;
            }
            if (!(object instanceof SkungeeVariable.Value[])) {
                Skungee.consoleMessage("A network variable under the index of \"" + this.variableString.toString(event) + "\" returned a value that could not be handled.");
                Skungee.consoleMessage("This could be due to an old format, in that case please reset this value or reset it.");
                Skungee.consoleMessage("Report this type to the developers of Skungee: &f" + variable.getClass().getName());
                return;
            }
            HashSet<Object> objects = new HashSet<Object>();
            for (SkungeeVariable.Value value : (SkungeeVariable.Value[])object) {
                objects.add(Classes.deserialize((String)value.type, (byte[])value.data));
            }
            if (objects.isEmpty()) {
                return;
            }
            Object[] delta = objects.toArray(new Object[objects.size()]);
            Bukkit.getScheduler().runTask((Plugin)Skungee.getInstance(), () -> {
                if (delta == null || delta.length > 0) {
                    variable.change(event, delta, Changer.ChangeMode.SET);
                }
                EffAsyncNetworkVariable.walk((TriggerItem)this.getNext(), (Event)event);
            });
        });
        return null;
    }

    protected void execute(Event event) {
    }
}

