/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.utils;

import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.limeglass.skungee.bungeecord.Skungee;

public class HasteConfigurationReader {
    private final Stream<String> stream;
    private final Skungee instance;
    private String product;
    private Set<Replacer> replacers = Sets.newHashSet((Object[])new Replacer[]{new Replacer("Bungeecord", "$os"){

        @Override
        public String replacement() {
            return System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
        }
    }, new Replacer("Bungeecord", "$java"){

        @Override
        public String replacement() {
            return System.getProperty("java.version") + " (" + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + ")";
        }
    }, new Replacer("Bungeecord", "$version"){

        @Override
        public String replacement() {
            return HasteConfigurationReader.this.instance.getProxy().getVersion();
        }
    }, new Replacer("Bungeecord", "$protocol"){

        @Override
        public String replacement() {
            return HasteConfigurationReader.this.instance.getProxy().getProtocolVersion() + "";
        }
    }});

    public HasteConfigurationReader(Stream<String> stream) {
        this.instance = Skungee.getInstance();
        this.stream = stream;
    }

    public HasteConfigurationReader addReplacer(Replacer replacer) {
        this.replacers.add(replacer);
        return this;
    }

    public HasteConfigurationReader read(Collection<String> keys) {
        this.product = this.stream.map(line -> {
            for (String key : keys) {
                for (Replacer replacer : this.replacers) {
                    if (!replacer.accepts(key)) continue;
                    line = line.replace(replacer.getSyntax(), replacer.replacement());
                }
            }
            return line;
        }).collect(Collectors.joining("\n"));
        return this;
    }

    public HasteConfigurationReader add(String string) {
        this.product = this.product + "\n" + string;
        return this;
    }

    public HasteConfigurationReader add(BufferedReader reader) {
        this.product = this.product + "\n" + reader.lines().collect(Collectors.joining("\n"));
        return this;
    }

    public String finish() {
        return this.product;
    }

    public abstract class Replacer {
        private final String syntax;
        private final String section;

        public Replacer(String section, String syntax) {
            this.section = section;
            this.syntax = syntax;
        }

        public boolean accepts(String section) {
            return section.equals(this.section);
        }

        public abstract String replacement();

        public String getSyntax() {
            return this.syntax;
        }
    }
}

