/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.sockets;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Base64;
import me.limeglass.skungee.bungeecord.Skungee;
import me.limeglass.skungee.objects.packets.ServerInstancesPacket;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;

public class ServerInstancesSockets {
    private static boolean checking;
    public static Socket bootstrap;
    private static int port;

    public static void setInstancesPort(int port) {
        ServerInstancesSockets.port = port;
    }

    public static void shutdown() {
        if (bootstrap == null) {
            return;
        }
        try {
            bootstrap.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Socket getBootstap() {
        for (int i = 0; i < Skungee.getConfig().getInt("Recievers.allowedTrys", 5); ++i) {
            try {
                return new Socket(InetAddress.getLocalHost(), port);
            }
            catch (IOException iOException) {
                continue;
            }
        }
        Skungee.consoleMessage("Could not establish a connection to the ServerInstances Bootstap.");
        return null;
    }

    public static Object sendPacket(ServerInstancesPacket packet) {
        if (port <= 0) {
            Skungee.consoleMessage("The recieving system for ServerInstances has not been setup yet, ", "make sure that you have ServerInstances installed or configured properly.");
        }
        try {
            if (bootstrap == null || !bootstrap.isConnected() || bootstrap.isClosed()) {
                if (checking) {
                    if (!packet.isReturnable().booleanValue()) {
                        while (checking) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        ServerInstancesSockets.sendPacket(packet);
                    }
                    return null;
                }
                checking = true;
                bootstrap = ServerInstancesSockets.getBootstap();
                if (bootstrap == null) {
                    return null;
                }
                bootstrap.setSoTimeout(10000);
                checking = false;
            }
            Skungee.debugMessage("Sending " + ServerInstancesSockets.getPacketDebug(packet) + " to the ServerInstances Bootstrap.");
            Configuration configuration = Skungee.getConfig();
            if (configuration.getBoolean("security.password.enabled", false)) {
                byte[] password = Skungee.getEncrypter().serialize(configuration.getString("security.password.password"));
                if (configuration.getBoolean("security.password.hash", true)) {
                    password = configuration.getBoolean("security.password.hashFile", false) && Skungee.getEncrypter().isFileHashed() != false ? Skungee.getEncrypter().getHashFromFile() : Skungee.getEncrypter().hash();
                }
                if (password != null) {
                    packet.setPassword(password);
                }
            }
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bootstrap.getOutputStream());
            if (configuration.getBoolean("security.encryption.enabled", false)) {
                byte[] serialized = Skungee.getEncrypter().serialize(packet);
                objectOutputStream.writeObject(Base64.getEncoder().encode(serialized));
            } else {
                objectOutputStream.writeObject(packet);
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(bootstrap.getInputStream());
            if (packet.isReturnable().booleanValue()) {
                if (configuration.getBoolean("security.encryption.enabled", false)) {
                    byte[] decoded = Base64.getDecoder().decode((byte[])objectInputStream.readObject());
                    return Skungee.getEncrypter().deserialize(decoded);
                }
                return objectInputStream.readObject();
            }
            objectOutputStream.close();
            objectInputStream.close();
        }
        catch (IOException | ClassNotFoundException e) {
            Skungee.exception(e, "Could not send packet " + (Object)((Object)packet.getType()));
        }
        return null;
    }

    private static String getPacketDebug(ServerInstancesPacket packet) {
        String debug = "Packet: " + (Object)((Object)packet.getType());
        if (packet.getObject() != null) {
            debug = packet.getObject().getClass().isArray() ? debug + " with data: " + Arrays.toString((Object[])packet.getObject()) : debug + " with data: " + packet.getObject();
        }
        if (packet.getSetObject() != null) {
            debug = packet.getSetObject().getClass().isArray() ? debug + " with settable data: " + Arrays.toString((Object[])packet.getSetObject()) : debug + " with settable data: " + packet.getSetObject();
        }
        return debug;
    }

    public static Object send(final ServerInstancesPacket packet) {
        if (packet == null) {
            return null;
        }
        if (packet.isReturnable().booleanValue()) {
            return ServerInstancesSockets.sendPacket(packet);
        }
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)Skungee.getInstance(), new Runnable(){

            @Override
            public void run() {
                ServerInstancesSockets.sendPacket(packet);
            }
        });
        return null;
    }
}

