/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.api;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import me.limeglass.skungee.UniversalSkungee;
import me.limeglass.skungee.bungeecord.sockets.BungeeSockets;
import me.limeglass.skungee.bungeecord.sockets.ServerTracker;
import me.limeglass.skungee.objects.ConnectedServer;
import me.limeglass.skungee.objects.SkungeePlayer;
import me.limeglass.skungee.objects.packets.BungeePacket;
import me.limeglass.skungee.objects.packets.BungeePacketType;
import me.limeglass.skungee.objects.packets.SkungeePacket;
import me.limeglass.skungee.objects.packets.SkungeePacketType;
import me.limeglass.skungee.spigot.Skungee;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class SkungeeAPI {
    public static boolean isBungeecord() {
        return UniversalSkungee.isBungeecord();
    }

    public static SkungeePlayer[] getPlayersFrom(ProxiedPlayer ... players) {
        SkungeePlayer[] skungees = new SkungeePlayer[players.length];
        for (int i = 0; i < players.length; ++i) {
            ProxiedPlayer player = players[i];
            skungees[i] = new SkungeePlayer(false, player.getUniqueId(), player.getName());
        }
        return skungees;
    }

    public static SkungeePlayer[] getPlayersFrom(Player ... players) {
        SkungeePlayer[] skungees = new SkungeePlayer[players.length];
        for (int i = 0; i < players.length; ++i) {
            Player player = players[i];
            skungees[i] = new SkungeePlayer(false, player.getUniqueId(), player.getName());
        }
        return skungees;
    }

    public static Object sendPacket(SkungeePacket packet) throws IllegalAccessException {
        if (SkungeeAPI.isBungeecord()) {
            throw new IllegalAccessException("A SkungeePacket may only be sent on a Spigot implementation, try BungeePacket.");
        }
        return Skungee.getInstance().getSockets().send(packet);
    }

    public static Object sendPacket(BungeePacket packet, ConnectedServer ... servers) throws IllegalAccessException {
        if (!SkungeeAPI.isBungeecord()) {
            throw new IllegalAccessException("A BungeePacket may only be sent on a Bungeecord implementation, try SkungeePacket.");
        }
        return BungeeSockets.send(packet, servers);
    }

    public static Optional<ConnectedServer[]> getConnectedServers(String server) {
        return Optional.of((Object)ServerTracker.get(server));
    }

    public static List<Object> sendPacketToAll(BungeePacket packet) throws IllegalAccessException {
        if (!SkungeeAPI.isBungeecord()) {
            throw new IllegalAccessException("A BungeePacket may only be sent on a Bungeecord implementation, try SkungeePacket.");
        }
        return BungeeSockets.sendAll(packet);
    }

    public static SkungeePlayer[] getOnlinePlayersFrom(String ... players) {
        return (SkungeePlayer[])Arrays.stream(players).map(name -> {
            if (SkungeeAPI.isBungeecord()) {
                return SkungeeAPI.getPlayersFrom(ProxyServer.getInstance().getPlayer(name))[0];
            }
            return SkungeeAPI.getPlayersFrom(Bukkit.getPlayer((String)name))[0];
        }).filter(player -> player != null).toArray(SkungeePlayer[]::new);
    }

    public static ConnectedServer[] getConnectedServers() throws IllegalAccessException {
        if (SkungeeAPI.isBungeecord()) {
            throw new IllegalAccessException("A BungeePacket may only be send on a Spigot implementation, try SkungeePacket.");
        }
        Set<ConnectedServer> servers = ServerTracker.getAll();
        return servers.toArray(new ConnectedServer[servers.size()]);
    }

    public static class BungeePacketBuilder
    implements PacketBuilder {
        private BungeePacketType type = BungeePacketType.CUSTOM;
        protected SkungeePlayer[] players;
        protected boolean returnable;
        protected Object object;
        protected String name;

        @Override
        public BungeePacketBuilder withPlayers(SkungeePlayer ... players) {
            this.players = players;
            return this;
        }

        public BungeePacketBuilder withPlayers(ProxiedPlayer ... players) {
            this.players = SkungeeAPI.getPlayersFrom(players);
            return this;
        }

        public BungeePacketBuilder withType(BungeePacketType type) {
            this.type = type;
            return this;
        }

        @Override
        public BungeePacketBuilder isReturnable(boolean returnable) {
            this.returnable = returnable;
            return this;
        }

        @Override
        public BungeePacketBuilder withObject(Object object) {
            this.object = object;
            return this;
        }

        @Override
        public BungeePacketBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public void send(ConnectedServer ... servers) throws IllegalAccessException {
            SkungeeAPI.sendPacket(this.build(), servers);
        }

        public void sendToAll() throws IllegalAccessException {
            SkungeeAPI.sendPacketToAll(this.build());
        }

        public BungeePacket build() {
            if (this.name != null) {
                if (this.object != null) {
                    if (this.players != null && this.players.length > 0) {
                        return new BungeePacket(this.returnable, this.name, this.object, this.players);
                    }
                    return new BungeePacket(this.returnable, this.name, this.object);
                }
                if (this.players != null && this.players.length > 0) {
                    return new BungeePacket(this.returnable, this.name, this.players);
                }
                return new BungeePacket(this.returnable, this.name);
            }
            if (this.object != null) {
                if (this.players != null && this.players.length > 0) {
                    return new BungeePacket(this.returnable, this.type, this.object, this.players);
                }
                return new BungeePacket(this.returnable, this.type, this.object);
            }
            if (this.players != null && this.players.length > 0) {
                return new BungeePacket(this.returnable, this.type, this.players);
            }
            return new BungeePacket(this.returnable, this.type, new SkungeePlayer[0]);
        }
    }

    public static class SkungeePacketBuilder
    implements PacketBuilder {
        private SkungeePacketType type = SkungeePacketType.CUSTOM;
        protected SkungeePlayer[] players;
        protected boolean returnable;
        protected Object object;
        protected String name;

        @Override
        public SkungeePacketBuilder withPlayers(SkungeePlayer ... players) {
            this.players = players;
            return this;
        }

        public SkungeePacketBuilder withPlayers(Player ... players) {
            this.players = SkungeeAPI.getPlayersFrom(players);
            return this;
        }

        public SkungeePacketBuilder withType(SkungeePacketType type) {
            this.type = type;
            return this;
        }

        @Override
        public SkungeePacketBuilder isReturnable(boolean returnable) {
            this.returnable = returnable;
            return this;
        }

        @Override
        public SkungeePacketBuilder withObject(Object object) {
            this.object = object;
            return this;
        }

        @Override
        public SkungeePacketBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public void send() throws IllegalAccessException {
            SkungeeAPI.sendPacket(this.build());
        }

        public SkungeePacket build() {
            if (this.name != null) {
                if (this.object != null) {
                    if (this.players != null && this.players.length > 0) {
                        return new SkungeePacket(this.returnable, this.name, this.object, this.players);
                    }
                    return new SkungeePacket(this.returnable, this.name, this.object);
                }
                if (this.players != null && this.players.length > 0) {
                    return new SkungeePacket(this.returnable, this.name, this.players);
                }
                return new SkungeePacket(this.returnable, this.name);
            }
            if (this.object != null) {
                if (this.players != null && this.players.length > 0) {
                    return new SkungeePacket(this.returnable, this.type, this.object, this.players);
                }
                return new SkungeePacket(this.returnable, this.type, this.object);
            }
            if (this.players != null && this.players.length > 0) {
                return new SkungeePacket(this.returnable, this.type, this.players);
            }
            return new SkungeePacket(this.returnable, this.type);
        }
    }

    private static interface PacketBuilder {
        public PacketBuilder withPlayers(SkungeePlayer ... var1);

        public PacketBuilder isReturnable(boolean var1);

        public PacketBuilder withObject(Object var1);

        public PacketBuilder withName(String var1);
    }
}

