/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.sockets;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.limeglass.skungee.EncryptionUtil;
import me.limeglass.skungee.UniversalSkungee;
import me.limeglass.skungee.objects.SkungeePlayer;
import me.limeglass.skungee.objects.events.SkungeeReturnedEvent;
import me.limeglass.skungee.objects.events.SkungeeSendingEvent;
import me.limeglass.skungee.objects.packets.HandshakePacket;
import me.limeglass.skungee.objects.packets.SkungeePacket;
import me.limeglass.skungee.objects.packets.SkungeePacketType;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.sockets.PacketQueue;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class Sockets {
    private final int port;
    private final int attempts;
    private final int delay;
    private final int handshake;
    private final int heartbeat;
    private final int keepAlive;
    private final Set<SkungeePacket> unsent = new HashSet<SkungeePacket>();
    private long last = System.currentTimeMillis();
    private final FileConfiguration configuration;
    private int heartbeatTask;
    private int keepAliveTask;
    private final BukkitScheduler scheduler;
    private final ExecutorService executor;
    private PacketQueue packetQueue;
    private final Skungee instance;
    private final Server server;
    private boolean connected;
    private final String host;
    private Socket bungeecord;

    public Sockets(Skungee instance) {
        this.instance = instance;
        this.server = instance.getServer();
        this.scheduler = this.server.getScheduler();
        this.configuration = instance.getConfig();
        this.port = this.configuration.getInt("port", 1337);
        this.executor = Executors.newSingleThreadExecutor();
        this.heartbeat = this.configuration.getInt("heartbeat", 60);
        this.host = this.configuration.getString("host", "0.0.0.0");
        this.delay = this.configuration.getInt("connection.delay", 1000);
        this.attempts = this.configuration.getInt("connection.attempts", 20);
        this.keepAlive = this.configuration.getInt("connection.keep-alive", 10) * 20;
        this.handshake = this.configuration.getInt("connection.handshake-delay", 2000);
        if (this.configuration.getBoolean("queue.enabled", true)) {
            this.packetQueue = new PacketQueue(this.configuration, instance, this);
        }
        this.connect();
    }

    public long getLastSent() {
        return this.last;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void keepAlive() {
        Skungee.consoleMessage("&6Going into keep alive mode...");
        this.keepAliveTask = this.scheduler.scheduleAsyncRepeatingTask((Plugin)this.instance, new Runnable(){

            @Override
            public void run() {
                try {
                    new Socket(Sockets.this.host, Sockets.this.port);
                    Bukkit.getScheduler().cancelTask(Sockets.this.keepAliveTask);
                    Skungee.consoleMessage("Connection established again!");
                    Sockets.this.connect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, 1L, (long)this.keepAlive);
    }

    private void connect() {
        Set<SkungeePlayer> whitelisted = this.server.getWhitelistedPlayers().stream().map(player -> new SkungeePlayer(true, player.getUniqueId(), player.getName())).collect(Collectors.toSet());
        Optional<ServerSocket> reciever = this.instance.getReciever();
        HandshakePacket packet = new HandshakePacket.Builder(whitelisted).withRecieverPort(reciever.isPresent() ? reciever.get().getLocalPort() : -1).hasReciever(this.configuration.getBoolean("reciever.enabled", false)).withMaxPlayers(this.server.getMaxPlayers()).withMotd(this.server.getMotd()).withPort(this.server.getPort()).withHeartbeat(this.heartbeat).build();
        this.scheduler.runTaskAsynchronously((Plugin)this.instance, () -> {
            Optional<Socket> optional = this.getSocketConnection();
            if (!optional.isPresent()) {
                Skungee.consoleMessage("&cThere was no socket found or was denied access at " + this.host + ":" + this.port);
                if (this.configuration.getBoolean("connection.disable", false)) {
                    Skungee.consoleMessage("&cSkungee is disabling...");
                    Bukkit.getPluginManager().disablePlugin((Plugin)this.instance);
                    return;
                }
                this.keepAlive();
                return;
            }
            this.bungeecord = optional.get();
            for (int i = 1; i < 6; ++i) {
                String state = this.send(packet, String.class);
                if (state != null && (state.equals("CONNECTED") || state.equals("ALREADY"))) {
                    this.connected = true;
                    Skungee.consoleMessage("Successfully connected to the Skungee on Bungeecord!");
                    break;
                }
                Skungee.consoleMessage("Ping packet had no response, configurion for the connection to Bungeecord Skungee may not be valid or blocked. Attempting to try again... " + i + "/5");
                try {
                    Thread.sleep(this.handshake);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.connected) {
                Bukkit.getScheduler().cancelTasks((Plugin)this.instance);
                this.keepAlive();
                return;
            }
            this.heartbeatTask = this.scheduler.scheduleAsyncRepeatingTask((Plugin)this.instance, new Runnable(){

                @Override
                public void run() {
                    Object answer = Sockets.this.send(new SkungeePacket(true, SkungeePacketType.HEARTBEAT, (Object)Sockets.this.server.getPort()));
                    if (answer == null) {
                        return;
                    }
                    if (((Boolean)answer).booleanValue()) {
                        Sockets.this.restart();
                    }
                }
            }, 1L, (long)this.heartbeat);
        });
    }

    Optional<Socket> getSocketConnection() {
        if (this.bungeecord != null && !this.bungeecord.isClosed()) {
            return Optional.ofNullable(this.bungeecord);
        }
        try {
            FutureTask<Optional<Socket>> future = new FutureTask<Optional<Socket>>(new SocketConnection());
            this.executor.execute(future);
            Optional<Socket> optional = future.get();
            if (optional.isPresent()) {
                this.bungeecord = optional.get();
            }
            return optional;
        }
        catch (InterruptedException | ExecutionException e) {
            return Optional.empty();
        }
    }

    public <T> T send(SkungeePacket packet, Class<T> expected) {
        Object object = this.send(packet);
        if (object == null) {
            return null;
        }
        if (expected.isInstance(object)) {
            return (T)object;
        }
        throw new IllegalArgumentException("The packet return type for " + UniversalSkungee.getPacketDebug(packet) + " was not the expected " + expected.getName() + ", it was " + object.getClass().getName());
    }

    public Object send(final SkungeePacket packet) {
        new Thread(() -> {
            SkungeeSendingEvent event = new SkungeeSendingEvent(packet);
            Bukkit.getPluginManager().callEvent((Event)event);
        });
        if (packet.isReturnable()) {
            Supplier<Object> supplier = () -> {
                if (this.connected || packet.getType() == SkungeePacketType.HANDSHAKE) {
                    return this.send_i(packet);
                }
                return null;
            };
            try {
                return CompletableFuture.supplyAsync(supplier).get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                return supplier.get();
            }
        }
        if (this.packetQueue != null) {
            this.packetQueue.queue(packet);
        } else {
            this.scheduler.runTaskAsynchronously((Plugin)this.instance, new Runnable(){

                @Override
                public void run() {
                    Sockets.this.send_i(packet);
                }
            });
        }
        return null;
    }

    public Object send_i(SkungeePacket packet) {
        Optional<Socket> optional = this.getSocketConnection();
        if (!optional.isPresent()) {
            if (this.configuration.getBoolean("hault", false)) {
                return this.send_i(packet);
            }
            if (this.configuration.getBoolean("queue.infinite-async-queue")) {
                return this.packetQueue.wait(packet);
            }
            Skungee.consoleMessage("Could not establish connection to Skungee on the Bungeecord!");
            Bukkit.getScheduler().cancelTask(this.heartbeatTask);
            this.unsent.add(packet);
            Skungee.consoleMessage("&6Attempting to reconnect to Skungee...");
            this.restart();
            return null;
        }
        this.bungeecord = optional.get();
        try {
            if (!this.unsent.isEmpty()) {
                Iterator<SkungeePacket> iterator = this.unsent.iterator();
                while (iterator.hasNext()) {
                    SkungeePacket effect = iterator.next();
                    this.send(effect);
                    iterator.remove();
                }
            }
            EncryptionUtil encryption = Skungee.getInstance().getEncrypter();
            String algorithm = this.configuration.getString("security.encryption.cipherAlgorithm", "AES/CBC/PKCS5Padding");
            String keyString = this.configuration.getString("security.encryption.cipherKey", "insert 16 length");
            if (!this.configuration.getBoolean("IgnoreSpamPackets", true)) {
                Skungee.debugMessage("Sending " + UniversalSkungee.getPacketDebug(packet));
            } else if (packet.getType() != SkungeePacketType.HEARTBEAT) {
                Skungee.debugMessage("Sending " + UniversalSkungee.getPacketDebug(packet));
            }
            if (this.configuration.getBoolean("security.password.enabled", false)) {
                byte[] password = encryption.serialize(this.configuration.getString("security.password.password"));
                if (this.configuration.getBoolean("security.password.hash", true)) {
                    password = this.configuration.getBoolean("security.password.hashFile", false) && encryption.isFileHashed() != false ? encryption.getHashFromFile() : encryption.hash();
                }
                if (password != null) {
                    packet.setPassword(password);
                }
            }
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.bungeecord.getOutputStream());
            if (this.configuration.getBoolean("security.encryption.enabled", false)) {
                byte[] serialized = encryption.serialize(packet);
                byte[] encrypted = encryption.encrypt(keyString, algorithm, serialized);
                objectOutputStream.writeObject(encrypted);
            } else {
                objectOutputStream.writeObject(packet);
            }
            this.last = System.currentTimeMillis();
            this.bungeecord.setSoTimeout(10000);
            ObjectInputStream objectInputStream = new ObjectInputStream(this.bungeecord.getInputStream());
            if (packet.isReturnable()) {
                Object value = null;
                value = this.configuration.getBoolean("security.encryption.enabled", false) ? encryption.decrypt(keyString, algorithm, (byte[])objectInputStream.readObject()) : objectInputStream.readObject();
                SkungeeReturnedEvent returned = new SkungeeReturnedEvent(packet, value);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)Skungee.getInstance(), () -> Bukkit.getPluginManager().callEvent((Event)returned));
                objectOutputStream.close();
                objectInputStream.close();
                this.bungeecord.close();
                return value;
            }
            objectOutputStream.close();
            objectInputStream.close();
            this.bungeecord.close();
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
        return null;
    }

    public void restart() {
        this.disconnect();
        this.connect();
    }

    public void disconnect() {
        Bukkit.getScheduler().cancelTask(this.heartbeatTask);
        Bukkit.getScheduler().cancelTask(this.keepAliveTask);
        if (this.packetQueue != null) {
            this.packetQueue.stop();
        }
        if (this.bungeecord != null) {
            try {
                this.bungeecord.close();
            }
            catch (IOException e) {
                Skungee.exception(e, "&cError closing main socket.");
            }
        }
        this.connected = false;
    }

    private class SocketConnection
    implements Callable<Optional<Socket>> {
        private SocketConnection() {
        }

        @Override
        public Optional<Socket> call() throws Exception {
            for (int i = 0; i < Sockets.this.attempts; ++i) {
                try {
                    return Optional.of(new Socket(Sockets.this.host, Sockets.this.port));
                }
                catch (IOException e) {
                    try {
                        Thread.sleep(Sockets.this.delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            return Optional.empty();
        }
    }
}

