/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.sockets;

import java.net.Socket;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import me.limeglass.skungee.objects.packets.SkungeePacket;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.sockets.Sockets;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class PacketQueue {
    private final Set<SkungeePacket> queue = new HashSet<SkungeePacket>();
    private final BukkitScheduler scheduler;
    private final Skungee instance;
    private final Sockets sockets;
    private int task;
    private int delay;

    public PacketQueue(FileConfiguration configuration, Skungee instance, Sockets sockets) {
        this.delay = configuration.getInt("queue.delay", 100);
        this.scheduler = instance.getServer().getScheduler();
        this.instance = instance;
        this.sockets = sockets;
    }

    public void stop() {
        this.scheduler.cancelTask(this.task);
    }

    public Object wait(SkungeePacket packet) {
        FutureTask<Object> future = new FutureTask<Object>(new WaitQueue(packet));
        this.sockets.getExecutor().execute(future);
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    public void queue(SkungeePacket ... packets) {
        for (SkungeePacket packet : packets) {
            this.queue.add(packet);
        }
        if (this.scheduler.isCurrentlyRunning(this.task)) {
            return;
        }
        this.task = this.scheduler.scheduleAsyncRepeatingTask((Plugin)this.instance, new Runnable(){

            @Override
            public void run() {
                if (PacketQueue.this.queue.isEmpty()) {
                    PacketQueue.this.scheduler.cancelTask(PacketQueue.this.task);
                    PacketQueue.this.task = -1;
                    return;
                }
                Iterator iterator = PacketQueue.this.queue.iterator();
                while (iterator.hasNext()) {
                    SkungeePacket packet = (SkungeePacket)iterator.next();
                    if (System.currentTimeMillis() - PacketQueue.this.sockets.getLastSent() > (long)(PacketQueue.this.delay + 1)) {
                        PacketQueue.this.sockets.send_i(packet);
                        iterator.remove();
                    }
                    try {
                        Thread.sleep(PacketQueue.this.delay);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, 0L, 1L);
    }

    private class WaitQueue
    implements Callable<Object> {
        private final SkungeePacket packet;

        public WaitQueue(SkungeePacket packet) {
            this.packet = packet;
        }

        @Override
        public Object call() throws Exception {
            Optional<Socket> optional;
            while (!(optional = PacketQueue.this.sockets.getSocketConnection()).isPresent()) {
                Thread.sleep(5000L);
            }
            return PacketQueue.this.sockets.send_i(this.packet);
        }
    }
}

