/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot;

import ch.njol.skript.doc.Description;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.util.SimpleEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.utils.annotations.AllChangers;
import me.limeglass.skungee.spigot.utils.annotations.Changers;
import me.limeglass.skungee.spigot.utils.annotations.Disabled;
import org.bukkit.configuration.file.FileConfiguration;

public class Syntax {
    private static Map<String, String[]> completeSyntax = new HashMap<String, String[]>();
    private static Map<String, String[]> modified = new HashMap<String, String[]>();

    public static String[] register(Class<?> syntaxClass, String ... syntax) {
        if (syntaxClass.isAnnotationPresent(Disabled.class)) {
            return null;
        }
        String type = "Expressions";
        if (Condition.class.isAssignableFrom(syntaxClass)) {
            type = "Conditions";
        } else if (Effect.class.isAssignableFrom(syntaxClass)) {
            type = "Effects";
        } else if (SimpleEvent.class.isAssignableFrom(syntaxClass)) {
            type = "Events";
        } else if (PropertyExpression.class.isAssignableFrom(syntaxClass)) {
            type = "PropertyExpressions";
        }
        String node = "Syntax." + type + "." + syntaxClass.getSimpleName() + ".";
        FileConfiguration syntaxConfiguration = Skungee.getInstance().getConfiguration("syntax");
        if (!syntaxConfiguration.isSet(node + "enabled")) {
            syntaxConfiguration.set(node + "enabled", (Object)true);
            Skungee.save("syntax");
        }
        if (syntaxClass.isAnnotationPresent(Changers.class) || syntaxClass.isAnnotationPresent(AllChangers.class)) {
            if (syntaxClass.isAnnotationPresent(AllChangers.class)) {
                syntaxConfiguration.set(node + "changers", (Object)"All changers");
            } else {
                Object[] changers = syntaxClass.getAnnotation(Changers.class).value();
                syntaxConfiguration.set(node + "changers", (Object)Arrays.toString(changers));
            }
            Skungee.save("syntax");
        }
        if (syntaxClass.isAnnotationPresent(Description.class)) {
            String[] descriptions = syntaxClass.getAnnotation(Description.class).value();
            syntaxConfiguration.set(node + "description", (Object)descriptions[0]);
            Skungee.save("syntax");
        }
        if (!syntaxConfiguration.getBoolean(node + "enabled")) {
            if (Skungee.getInstance().getConfig().getBoolean("NotRegisteredSyntax", false)) {
                Skungee.consoleMessage(node.toString() + " didn't register!");
            }
            return null;
        }
        if (!syntaxConfiguration.isSet(node + "syntax")) {
            syntaxConfiguration.set(node + "syntax", (Object)syntax);
            Skungee.save("syntax");
            return Syntax.add(syntaxClass.getSimpleName(), syntax);
        }
        List data = syntaxConfiguration.getStringList(node + "syntax");
        if (!Arrays.equals(data.toArray(new String[data.size()]), syntax)) {
            modified.put(syntaxClass.getSimpleName(), syntax);
        }
        if (syntaxConfiguration.isList(node + "syntax")) {
            List syntaxes = syntaxConfiguration.getStringList(node + "syntax");
            return Syntax.add(syntaxClass.getSimpleName(), syntaxes.toArray(new String[syntaxes.size()]));
        }
        return Syntax.add(syntaxClass.getSimpleName(), syntaxConfiguration.getString(node + "syntax"));
    }

    public static Boolean isModified(Class syntaxClass) {
        return modified.containsKey(syntaxClass.getSimpleName());
    }

    public static String[] get(String syntaxClass) {
        return completeSyntax.get(syntaxClass);
    }

    private static String[] add(String syntaxClass, String ... syntax) {
        if (!completeSyntax.containsValue(syntax)) {
            completeSyntax.put(syntaxClass, syntax);
        }
        return syntax;
    }
}

