/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.objects.packets;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import me.limeglass.skungee.objects.SkungeePlayer;
import me.limeglass.skungee.objects.packets.SkungeePacket;
import me.limeglass.skungee.objects.packets.SkungeePacketType;
import org.apache.commons.lang.Validate;

public class HandshakePacket
extends SkungeePacket {
    private static final long serialVersionUID = 1118568736287179260L;
    private final Set<SkungeePlayer> whitelisted = new HashSet<SkungeePlayer>();
    private final int port;
    private final int recieverPort;
    private final int heartbeat;
    private final int max;
    private final boolean reciever;
    private final String motd;

    public HandshakePacket(String motd, int max, boolean reciever, int port, int recieverPort, int heartbeat, Collection<SkungeePlayer> whitelisted) {
        super(true, SkungeePacketType.HANDSHAKE);
        this.whitelisted.addAll(whitelisted);
        this.recieverPort = recieverPort;
        this.heartbeat = heartbeat;
        this.reciever = reciever;
        this.motd = motd;
        this.port = port;
        this.max = max;
    }

    public Set<SkungeePlayer> getWhitelisted() {
        return this.whitelisted;
    }

    public int getMaximumPlayers() {
        return this.max;
    }

    public int getRecieverPort() {
        return this.recieverPort;
    }

    public boolean hasReciever() {
        return this.reciever;
    }

    public int getHeartbeat() {
        return this.heartbeat;
    }

    public String getMotd() {
        return this.motd;
    }

    public int getPort() {
        return this.port;
    }

    public static class Builder {
        private int port;
        private int recieverPort;
        private int heartbeat;
        private int max;
        private Collection<SkungeePlayer> whitelisted;
        private boolean reciever;
        private String motd;

        public Builder(Collection<SkungeePlayer> whitelisted) {
            this.whitelisted = whitelisted;
        }

        public Builder withRecieverPort(int recieverPort) {
            this.recieverPort = recieverPort;
            return this;
        }

        public Builder hasReciever(boolean reciever) {
            this.reciever = reciever;
            return this;
        }

        public Builder withHeartbeat(int heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        public Builder withMotd(String motd) {
            this.motd = motd;
            return this;
        }

        public Builder withMaxPlayers(int max) {
            this.max = max;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public HandshakePacket build() {
            Validate.noNullElements((Object[])new Object[]{this.port, this.recieverPort, this.heartbeat, this.max, this.whitelisted, this.reciever, this.motd});
            return new HandshakePacket(this.motd, this.max, this.reciever, this.port, this.recieverPort, this.heartbeat, this.whitelisted);
        }
    }
}

