/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.limeglass.skungee.bungeecord.Skungee;
import me.limeglass.skungee.bungeecord.protocol.ProtocolPlayer;
import me.limeglass.skungee.objects.packets.ProtocolPacket;

public abstract class ProtocolPacketHandler {
    protected static List<ProtocolPacketHandler> registered = new ArrayList<ProtocolPacketHandler>();
    protected static int protocol = Skungee.getInstance().getProxy().getProtocolVersion();
    protected int packetId;
    protected int maxProtocol;
    protected int minProtocol;
    protected String name;

    protected static void registerProtocolHandler(ProtocolPacketHandler handler, String name, int packetId, int minProtocol, int maxProtocol) {
        handler.setName(name);
        handler.setPacketId(packetId);
        handler.setMinProtocol(minProtocol);
        handler.setMaxProtocol(maxProtocol);
        if (!registered.contains(handler)) {
            registered.add(handler);
        }
    }

    public static List<ProtocolPacketHandler> getHandlers(int packetId, ProtocolPlayer player) {
        return registered.parallelStream().filter(handler -> handler.getPacketId() == packetId).filter(handler -> handler.getMaxProtocol() >= player.getProtocolVersion() && handler.getMinProtocol() <= player.getProtocolVersion()).collect(Collectors.toList());
    }

    public int getPacketId() {
        return this.packetId;
    }

    public void setPacketId(int packetId) {
        this.packetId = packetId;
    }

    public int getMaxProtocol() {
        return this.maxProtocol;
    }

    public void setMaxProtocol(int maxProtocol) {
        this.maxProtocol = maxProtocol;
    }

    public int getMinProtocol() {
        return this.minProtocol;
    }

    public void setMinProtocol(int minProtocol) {
        this.minProtocol = minProtocol;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract boolean handlePacket(ProtocolPacket var1);
}

