/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.sockets;

import java.io.IOException;
import java.net.ServerSocket;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.sockets.SpigotRunnable;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class Reciever {
    private final FileConfiguration configuration;
    private final BukkitScheduler scheduler;
    private ServerSocket reciever;

    public Reciever(final Skungee instance) {
        this.configuration = instance.getConfig();
        this.scheduler = instance.getServer().getScheduler();
        this.scheduler.runTaskAsynchronously((Plugin)instance, new Runnable(){

            @Override
            public void run() {
                int port = Reciever.this.configuration.getInt("reciever.port", 1338);
                try {
                    if (Reciever.this.configuration.getBoolean("reciever.automatic", true)) {
                        Reciever.this.reciever = Reciever.this.find();
                    } else {
                        Reciever.this.reciever = new ServerSocket(port, 69);
                    }
                    instance.loadSockets();
                    Skungee.consoleMessage("Reciever established on port " + Reciever.this.reciever.getLocalPort());
                    while (!Reciever.this.reciever.isClosed()) {
                        try {
                            new Thread(new SpigotRunnable(Reciever.this.reciever.accept())).start();
                        }
                        catch (IOException e) {
                            Skungee.exception(e, "Socket couldn't be accepted.");
                        }
                    }
                }
                catch (IOException e) {
                    Skungee.exception(e, "Reciever couldn't be created on port: " + port);
                }
            }
        });
    }

    public ServerSocket getReciever() {
        return this.reciever;
    }

    private ServerSocket find() {
        int starting;
        int ending = this.configuration.getInt("reciever.max-port", 65534);
        IOException lastException = null;
        for (starting = this.configuration.getInt("reciever.starting-port", 1000); starting <= this.configuration.getInt("reciever.max-port", 65534); ++starting) {
            try {
                return new ServerSocket(starting);
            }
            catch (IOException e) {
                lastException = e;
                continue;
            }
        }
        if (lastException != null) {
            Skungee.exception(lastException, "Couldn't find a port between " + starting + " and " + ending);
        }
        return null;
    }
}

