/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.objects;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.limeglass.skungee.objects.SkungeePlayer;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public interface Returnable {
    public static final SkungeeReturnable returnable = Utils.getEnum(SkungeeReturnable.class, Skungee.getInstance().getConfig().getString("SkungeeReturn", "STRING"));

    default public Object[] convert(SkungeeReturnable type, SkungeePlayer ... players) {
        HashSet<Object> converted = new HashSet<Object>();
        block6: for (SkungeePlayer player : players) {
            if (player == null) continue;
            switch (type) {
                case OFFLINEPLAYER: {
                    OfflinePlayer offline = Bukkit.getOfflinePlayer((UUID)player.getUUID());
                    if (Skungee.getInstance().getConfig().getBoolean("SkungeeReturnUUID", false) && offline != null) {
                        converted.add(Bukkit.getOfflinePlayer((UUID)player.getUUID()));
                        continue block6;
                    }
                    converted.add(Bukkit.getOfflinePlayer((String)player.getName()));
                    continue block6;
                }
                case SKUNGEE: {
                    converted.add(player);
                    continue block6;
                }
                case STRING: {
                    converted.add(player.getName());
                    continue block6;
                }
                case UUID: {
                    converted.add(player.getUUID().toString());
                }
            }
        }
        if (returnable.getReturnType() == String.class) {
            return converted.toArray(new String[converted.size()]);
        }
        if (returnable.getReturnType() == OfflinePlayer.class) {
            return converted.toArray(new OfflinePlayer[converted.size()]);
        }
        return converted.toArray(new SkungeePlayer[converted.size()]);
    }

    default public Object[] convert(Set<SkungeePlayer> players) {
        return this.convert(players.toArray(new SkungeePlayer[players.size()]));
    }

    default public Object[] convert(SkungeePlayer ... players) {
        return this.convert(returnable, players);
    }

    public static Class<?> getReturnType() {
        return returnable == null ? String.class : returnable.getReturnType();
    }

    public static enum SkungeeReturnable {
        STRING(1),
        UUID(1),
        OFFLINEPLAYER(2),
        SKUNGEE(3);

        private int value;

        private SkungeeReturnable(int value) {
            this.value = value;
        }

        public Class<?> getReturnType() {
            return this.value == 1 ? String.class : (this.value == 2 ? OfflinePlayer.class : SkungeePlayer.class);
        }
    }
}

