/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.managers;

import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.limeglass.skungee.bungeecord.Skungee;
import me.limeglass.skungee.bungeecord.database.Database;
import me.limeglass.skungee.bungeecord.database.H2Database;
import me.limeglass.skungee.objects.SkungeePlayer;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;

public class PlayerTimeManager {
    private Database<PlayerTime> database;

    public PlayerTimeManager(Skungee instance) {
        try {
            this.database = new H2Database<PlayerTime>(instance, "playtime", (Type)((Object)PlayerTime.class), new HashMap());
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
        ProxyServer proxy = ProxyServer.getInstance();
        proxy.getScheduler().schedule((Plugin)instance, () -> proxy.getPlayers().forEach(player -> {
            String uuid = player.getUniqueId() + "";
            PlayerTime time = this.database.get(uuid, new PlayerTime(player.getUniqueId()));
            if (time == null) {
                this.database.put(uuid, new PlayerTime(player.getUniqueId()));
                return;
            }
            time.increment(player.getServer().getInfo().getName());
            this.database.put(uuid, time);
        }), 0L, 1L, TimeUnit.SECONDS);
    }

    public PlayerTime getPlayerTime(SkungeePlayer player) {
        return this.getPlayerTime(player.getUUID());
    }

    public PlayerTime getPlayerTime(ProxiedPlayer player) {
        return this.getPlayerTime(player.getUniqueId());
    }

    public PlayerTime getPlayerTime(UUID uuid) {
        return this.database.get(uuid + "", new PlayerTime(uuid));
    }

    public static class PlayerTime {
        private final Map<String, Integer> times = new HashMap<String, Integer>();
        private final UUID uuid;

        public PlayerTime(UUID uuid) {
            this.uuid = uuid;
        }

        public PlayerTime(UUID uuid, Map<String, Integer> existing) {
            this.uuid = uuid;
            this.times.putAll(existing);
        }

        public void increment(String server) {
            int time = this.times.getOrDefault(server, 0);
            this.times.put(server, time + 1);
        }

        public int getSeconds(String server) {
            return this.times.getOrDefault(server, 0);
        }

        public Set<Integer> getSeconds(String ... servers) {
            return Arrays.stream(servers).map(server -> this.times.getOrDefault(server, 0)).collect(Collectors.toSet());
        }

        public int getTotal() {
            return this.times.values().stream().mapToInt(Integer::intValue).sum();
        }

        public UUID getUniqueId() {
            return this.uuid;
        }

        public Map<String, Integer> getTimes() {
            return this.times;
        }
    }
}

