/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.handlers;

import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.ArrayList;
import me.limeglass.skungee.bungeecord.handlercontroller.SkungeeBungeeHandler;
import me.limeglass.skungee.bungeecord.variables.VariableManager;
import me.limeglass.skungee.objects.SkungeeEnums;
import me.limeglass.skungee.objects.SkungeeVariable;
import me.limeglass.skungee.objects.packets.SkungeePacket;
import me.limeglass.skungee.objects.packets.SkungeePacketType;

public class NetworkVariableHandler
extends SkungeeBungeeHandler {
    public NetworkVariableHandler() {
        super(SkungeePacketType.NETWORKVARIABLE);
    }

    public SkungeeVariable.Value[] handlePacket(SkungeePacket packet, InetAddress address) {
        Object object = packet.getObject();
        if (object == null) {
            return null;
        }
        if (object instanceof SkungeeVariable) {
            SkungeeVariable variable = (SkungeeVariable)object;
            String variableString = variable.getVariableString();
            SkungeeVariable.Value[] values = variable.getValues();
            if (variableString == null) {
                return null;
            }
            SkungeeEnums.SkriptChangeMode mode = packet.getChangeMode();
            if (mode != null) {
                ArrayList modify = new ArrayList();
                Object[] data = VariableManager.getMainStorage().get(variableString);
                if (data != null) {
                    modify = Lists.newArrayList((Object[])data);
                }
                if (values == null && mode != SkungeeEnums.SkriptChangeMode.RESET && mode != SkungeeEnums.SkriptChangeMode.DELETE) {
                    return null;
                }
                switch (mode) {
                    case ADD: {
                        VariableManager.getMainStorage().delete(variableString);
                        for (SkungeeVariable.Value value : values) {
                            modify.add(value);
                        }
                        VariableManager.getMainStorage().set(variableString, modify.toArray(new SkungeeVariable.Value[modify.size()]));
                        break;
                    }
                    case REMOVE_ALL: 
                    case REMOVE: {
                        VariableManager.getMainStorage().remove(values, variableString);
                        break;
                    }
                    case DELETE: 
                    case RESET: {
                        VariableManager.getMainStorage().delete(variableString);
                        break;
                    }
                    case SET: {
                        VariableManager.getMainStorage().set(variableString, values);
                    }
                }
            }
        } else if (object instanceof String && packet.getChangeMode() == null) {
            return VariableManager.getMainStorage().get((String)object);
        }
        return null;
    }
}

