/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.database;

import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import me.limeglass.skungee.bungeecord.Skungee;
import me.limeglass.skungee.bungeecord.database.Database;
import me.limeglass.skungee.bungeecord.database.Serializer;

public class H2Database<T>
extends Database<T> {
    private final String tablename;
    private Connection connection;
    private final Type type;

    public H2Database(Skungee instance, String tablename, Type type, Map<Type, Serializer<?>> serializers) throws SQLException, ClassNotFoundException {
        super(serializers);
        this.tablename = tablename;
        this.type = type;
        Class.forName("org.h2.Driver");
        String url = "jdbc:h2:" + instance.getDataFolder().getAbsolutePath() + File.separator + "database";
        this.connection = DriverManager.getConnection(url);
        if (this.connection == null) {
            return;
        }
        PreparedStatement stmt = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS %table (`id` CHAR(36) PRIMARY KEY, `data` TEXT);".replace("%table", tablename));
        stmt.executeUpdate();
        stmt.close();
    }

    @Override
    public T get(String key, T def) {
        Object result = def;
        try {
            result = CompletableFuture.supplyAsync(() -> {
                Object resultReturn = def;
                try {
                    PreparedStatement statement = this.connection.prepareStatement("SELECT `data` FROM %table WHERE `id` = ?;".replace("%table", this.tablename));
                    statement.setString(1, key.toLowerCase(Locale.US));
                    ResultSet rs = statement.executeQuery();
                    while (rs.next()) {
                        String json = rs.getString("data");
                        try {
                            resultReturn = this.deserialize(json, this.type);
                        }
                        catch (JsonSyntaxException e) {
                            e.printStackTrace();
                            return def;
                        }
                        if (resultReturn != null) continue;
                        return def;
                    }
                    statement.close();
                    return resultReturn;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return resultReturn;
                }
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void put(String key, T value) {
        new Thread(() -> {
            try {
                if (value != null) {
                    PreparedStatement statement = this.connection.prepareStatement("MERGE INTO %table (id, data) KEY (id) VALUES (?,?);".replace("%table", this.tablename));
                    statement.setString(1, key.toLowerCase(Locale.US));
                    String json = this.serialize(value, this.type);
                    statement.setString(2, json);
                    statement.executeUpdate();
                    statement.close();
                } else {
                    PreparedStatement statement = this.connection.prepareStatement("DELETE FROM %table WHERE id = ?".replace("%table", this.tablename));
                    statement.setString(1, key.toLowerCase(Locale.US));
                    statement.executeUpdate();
                    statement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }).start();
    }

    @Override
    public boolean has(String key) {
        boolean result = false;
        try {
            PreparedStatement statement = this.connection.prepareStatement("SELECT `id` FROM %table WHERE `id` = ?;".replace("%table", this.tablename));
            statement.setString(1, key.toLowerCase(Locale.US));
            ResultSet rs = statement.executeQuery();
            result = rs.next();
            rs.close();
            statement.close();
            return result;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return result;
        }
    }

    @Override
    public void clear() {
        new Thread(() -> {
            try {
                PreparedStatement statement = this.connection.prepareStatement("DELETE FROM %table;".replace("%table", this.tablename));
                statement.executeQuery();
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }).start();
    }

    @Override
    public Set<String> getKeys() {
        try {
            return CompletableFuture.supplyAsync(() -> {
                HashSet<String> set = new HashSet<String>();
                try {
                    PreparedStatement statement = this.connection.prepareStatement("SELECT `id` FROM %table;".replace("%table", this.tablename));
                    ResultSet result = statement.executeQuery();
                    while (result.next()) {
                        set.add(result.getString("id"));
                    }
                    result.close();
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return set;
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return Sets.newHashSet();
        }
    }
}

