/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import me.limeglass.skungee.bungeecord.Skungee;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class BungeeConfigSaver {
    private final File folder;
    private final File config;
    private final File oldconfig;
    private Configuration configuration;

    public BungeeConfigSaver(Skungee instance) {
        this.folder = new File(instance.getDataFolder(), "old-configs/");
        this.config = new File(instance.getDataFolder(), "config.yml");
        this.load();
        this.oldconfig = new File(this.folder, this.configuration.getString("version", "old") + "-config.yml");
        if (!this.folder.exists()) {
            this.folder.mkdir();
        }
    }

    private void load() {
        try {
            this.configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.config);
        }
        catch (IOException exception) {
            Skungee.exception(exception, "Failed to load the configuration.");
        }
    }

    public void execute() {
        try {
            Files.move((File)this.config, (File)this.oldconfig);
        }
        catch (IOException exception) {
            Skungee.exception(exception, "Failed to save the old configuration.");
        }
    }
}

