/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.sockets;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import me.limeglass.skungee.EncryptionUtil;
import me.limeglass.skungee.UniversalSkungee;
import me.limeglass.skungee.objects.SkungeePlayer;
import me.limeglass.skungee.objects.events.SkungeeReturnedEvent;
import me.limeglass.skungee.objects.events.SkungeeSendingEvent;
import me.limeglass.skungee.objects.packets.SkungeePacket;
import me.limeglass.skungee.objects.packets.SkungeePacketType;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.sockets.PacketQueue;
import me.limeglass.skungee.spigot.sockets.Reciever;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class Sockets {
    public static Map<InetAddress, Integer> attempts = new HashMap<InetAddress, Integer>();
    public static Set<InetAddress> blocked = new HashSet<InetAddress>();
    public static Set<SkungeePacket> unsent = new HashSet<SkungeePacket>();
    private static boolean restart = true;
    private static boolean checking;
    private static boolean isConnected;
    public static Long last;
    private static int task;
    private static int heartbeat;
    private static int keepAlive;
    public static Socket bungeecord;

    public static boolean isConnected() {
        return isConnected;
    }

    private static void startHeartbeat() {
        task = Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)Skungee.getInstance(), new Runnable(){

            @Override
            public void run() {
                Boolean answer = (Boolean)Sockets.send(new SkungeePacket(true, SkungeePacketType.HEARTBEAT, (Object)Bukkit.getPort()));
                if (answer != null && answer.booleanValue()) {
                    Sockets.stop(true);
                }
            }
        }, 1L, (long)Skungee.getInstance().getConfig().getInt("heartbeat", 30));
    }

    private static void keepAlive() {
        restart = true;
        keepAlive = Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)Skungee.getInstance(), new Runnable(){

            @Override
            public void run() {
                try {
                    new Socket(Skungee.getInstance().getConfig().getString("host", "0.0.0.0"), Skungee.getInstance().getConfig().getInt("port", 1337));
                    Bukkit.getScheduler().cancelTask(keepAlive);
                    Skungee.consoleMessage("Connection established again!");
                    Sockets.connect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, 1L, (long)(Skungee.getInstance().getConfig().getInt("keepAlive", 10) * 20));
    }

    public static void connect() {
        HashSet<SkungeePlayer> whitelisted = new HashSet<SkungeePlayer>();
        for (OfflinePlayer player : Bukkit.getWhitelistedPlayers()) {
            whitelisted.add(new SkungeePlayer(true, player.getUniqueId(), player.getName()));
        }
        FileConfiguration configuration = Skungee.getInstance().getConfig();
        final ArrayList<Object> data = new ArrayList<Object>(Arrays.asList(configuration.getBoolean("Reciever.enabled", false), Reciever.getReciever().getLocalPort(), Bukkit.getPort(), whitelisted, configuration.getInt("heartbeat", 30) * 60, Bukkit.getMotd(), Bukkit.getMaxPlayers()));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Skungee.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (Sockets.getSocketConnection() == null) {
                    Sockets.stop(false);
                    restart = true;
                } else {
                    for (int i = 0; i < 10; ++i) {
                        String state = (String)Sockets.send(new SkungeePacket(true, SkungeePacketType.HANDSHAKE, (Object)data));
                        if (state != null && (state.equalsIgnoreCase("CONNECTED") || state.equalsIgnoreCase("ALREADY"))) {
                            isConnected = true;
                            Skungee.consoleMessage("Successfully connected to the Bungeecord Skungee.");
                            break;
                        }
                        Skungee.debugMessage("Ping packet had no response, configurion for the connection to Bungeecord Skungee may not be valid or blocked. Attempting to try again... " + (i + 1) + "/10");
                        try {
                            Thread.sleep(TimeUnit.SECONDS.toMillis(3L));
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (isConnected) {
                        Sockets.startHeartbeat();
                    } else {
                        Sockets.keepAlive();
                    }
                }
            }
        });
    }

    private static Socket getSocketConnection() {
        FileConfiguration configuration = Skungee.getInstance().getConfig();
        for (int i = 0; i < configuration.getInt("maxAttempts", 20); ++i) {
            try {
                return new Socket(configuration.getString("host", "0.0.0.0"), configuration.getInt("port", 1337));
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return null;
    }

    public static Object send(final SkungeePacket packet) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Skungee.getInstance(), () -> {
            SkungeeSendingEvent event = new SkungeeSendingEvent(packet);
            Bukkit.getPluginManager().callEvent((Event)event);
        });
        if (packet.isReturnable()) {
            return isConnected ? Sockets.send_i(packet) : (packet.getType() == SkungeePacketType.HANDSHAKE ? Sockets.send_i(packet) : null);
        }
        if (Skungee.getInstance().getConfig().getBoolean("Queue.enabled", false)) {
            PacketQueue.queue(packet);
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Skungee.getInstance(), new Runnable(){

                @Override
                public void run() {
                    Sockets.send_i(packet);
                }
            });
        }
        return null;
    }

    public static Object send_i(SkungeePacket packet) {
        try {
            if (!checking) {
                checking = true;
                bungeecord = Sockets.getSocketConnection();
                checking = false;
                FileConfiguration configuration = Skungee.getInstance().getConfig();
                if (bungeecord == null) {
                    if (configuration.getBoolean("hault", false)) {
                        return Sockets.send_i(packet);
                    }
                    Skungee.consoleMessage("Could not establish connection to Skungee on the Bungeecord!");
                    unsent.add(packet);
                    Bukkit.getScheduler().cancelTask(heartbeat);
                    Sockets.stop(restart);
                    restart = false;
                } else {
                    if (!unsent.isEmpty()) {
                        for (SkungeePacket p : unsent) {
                            Sockets.send(p);
                            unsent.remove(p);
                        }
                    }
                    EncryptionUtil encryption = new EncryptionUtil(Skungee.getInstance(), (Boolean)true);
                    String algorithm = configuration.getString("security.encryption.cipherAlgorithm", "AES/CBC/PKCS5Padding");
                    String keyString = configuration.getString("security.encryption.cipherKey", "insert 16 length");
                    if (!configuration.getBoolean("IgnoreSpamPackets", true)) {
                        Skungee.debugMessage("Sending " + UniversalSkungee.getPacketDebug(packet));
                    } else if (packet.getType() != SkungeePacketType.HEARTBEAT) {
                        Skungee.debugMessage("Sending " + UniversalSkungee.getPacketDebug(packet));
                    }
                    if (configuration.getBoolean("security.password.enabled", false)) {
                        byte[] password = encryption.serialize(configuration.getString("security.password.password"));
                        if (configuration.getBoolean("security.password.hash", true)) {
                            password = configuration.getBoolean("security.password.hashFile", false) && encryption.isFileHashed() != false ? encryption.getHashFromFile() : encryption.hash();
                        }
                        if (password != null) {
                            packet.setPassword(password);
                        }
                    }
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(bungeecord.getOutputStream());
                    if (configuration.getBoolean("security.encryption.enabled", false)) {
                        byte[] serialized = encryption.serialize(packet);
                        byte[] encrypted = encryption.encrypt(keyString, algorithm, serialized);
                        objectOutputStream.writeObject(encrypted);
                    } else {
                        objectOutputStream.writeObject(packet);
                    }
                    last = System.currentTimeMillis();
                    bungeecord.setSoTimeout(10000);
                    ObjectInputStream objectInputStream = new ObjectInputStream(bungeecord.getInputStream());
                    if (packet.isReturnable()) {
                        Object value = null;
                        value = configuration.getBoolean("security.encryption.enabled", false) ? encryption.decrypt(keyString, algorithm, (byte[])objectInputStream.readObject()) : objectInputStream.readObject();
                        SkungeeReturnedEvent returned = new SkungeeReturnedEvent(packet, value);
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Skungee.getInstance(), () -> Bukkit.getPluginManager().callEvent((Event)returned));
                        objectOutputStream.close();
                        objectInputStream.close();
                        bungeecord.close();
                        return value;
                    }
                    objectOutputStream.close();
                    objectInputStream.close();
                    bungeecord.close();
                }
            }
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
        return null;
    }

    public static void onPluginDisabling() {
        Bukkit.getScheduler().cancelTask(task);
        Bukkit.getScheduler().cancelTask(heartbeat);
        Bukkit.getScheduler().cancelTask(keepAlive);
        if (bungeecord != null) {
            try {
                bungeecord.close();
            }
            catch (IOException e) {
                Skungee.exception(e, "&cError closing main socket.");
            }
        }
    }

    public static void stop(Boolean reconnect) {
        Bukkit.getScheduler().cancelTask(task);
        Bukkit.getScheduler().cancelTask(heartbeat);
        Bukkit.getScheduler().cancelTask(keepAlive);
        FileConfiguration configuration = Skungee.getInstance().getConfig();
        if (bungeecord != null) {
            try {
                bungeecord.close();
            }
            catch (IOException e) {
                Skungee.exception(e, "&cError closing main socket.");
            }
        }
        isConnected = false;
        if (reconnect.booleanValue()) {
            Skungee.consoleMessage("&6Attempting to reconnect to Skungee...");
            Sockets.connect();
        } else if (configuration.getBoolean("reconnect", false)) {
            Skungee.consoleMessage("&6Going into keep alive mode...");
            Sockets.keepAlive();
        } else {
            Skungee.consoleMessage("&cDisconnected from Skungee!");
            Skungee.consoleMessage("Could be incorrect Skungee details, there was no socket found or was denied access. For socket at " + configuration.getString("host", "0.0.0.0") + ":" + configuration.getInt("port", 1337));
        }
    }

    static {
        last = System.currentTimeMillis();
    }
}

