/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.handlers;

import com.imaginarycode.minecraft.redisbungee.RedisBungee;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.limeglass.skungee.UniversalSkungee;
import me.limeglass.skungee.bungeecord.Skungee;
import me.limeglass.skungee.bungeecord.sockets.BungeeSockets;
import me.limeglass.skungee.bungeecord.sockets.ServerInstancesSockets;
import me.limeglass.skungee.bungeecord.sockets.ServerTracker;
import me.limeglass.skungee.objects.ConnectedServer;
import me.limeglass.skungee.objects.SkungeeEnums;
import me.limeglass.skungee.objects.SkungeePlayer;
import me.limeglass.skungee.objects.packets.BungeePacket;
import me.limeglass.skungee.objects.packets.BungeePacketType;
import me.limeglass.skungee.objects.packets.ServerInstancesPacket;
import me.limeglass.skungee.objects.packets.ServerInstancesPacketType;
import me.limeglass.skungee.objects.packets.SkungeePacket;
import me.limeglass.skungee.spigot.utils.Utils;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;

public class SkungeePacketHandler {
    /*
     * WARNING - void declaration
     */
    public static Object handlePacket(SkungeePacket packet, InetAddress address) {
        Skungee.debugMessage("Recieved " + UniversalSkungee.getPacketDebug(packet));
        ArrayList<void> players = new ArrayList<void>();
        if (packet.getPlayers() != null) {
            for (SkungeePlayer skungeePlayer : packet.getPlayers()) {
                void var7_66;
                Object var7_67 = null;
                if (Skungee.getConfig().getBoolean("IncomingUUIDs", true) && skungeePlayer.getUUID() != null) {
                    ProxiedPlayer proxiedPlayer = ProxyServer.getInstance().getPlayer(skungeePlayer.getUUID());
                    if (proxiedPlayer == null) {
                        ProxiedPlayer proxiedPlayer2 = ProxyServer.getInstance().getPlayer(skungeePlayer.getName());
                    }
                } else if (skungeePlayer.getName() != null) {
                    ProxiedPlayer proxiedPlayer = ProxyServer.getInstance().getPlayer(skungeePlayer.getName());
                }
                if (var7_66 == null) continue;
                players.add(var7_66);
            }
        }
        switch (packet.getType()) {
            case KICKPLAYERS: {
                String message = "Kicked from the bungeecord network.";
                if (packet.getObject() != null) {
                    message = (String)packet.getObject();
                } else if (Skungee.getConfig().getBoolean("Misc.UseFunnyKickMessages")) {
                    List messages = Skungee.getConfig().getStringList("Misc.FunnyKickMessages");
                    Collections.shuffle(messages);
                    message = (String)messages.get(0);
                }
                for (ProxiedPlayer p : ProxyServer.getInstance().getPlayers()) {
                    p.disconnect((BaseComponent)new TextComponent(message));
                }
                break;
            }
            case KICKPLAYER: {
                if (players.isEmpty()) break;
                String msg = "Kicked from the bungeecord network.";
                if (packet.getObject() != null) {
                    msg = (String)packet.getObject();
                } else if (Skungee.getConfig().getBoolean("Misc.UseFunnyKickMessages")) {
                    List messages = Skungee.getConfig().getStringList("Misc.FunnyKickMessages");
                    Collections.shuffle(messages);
                    msg = (String)messages.get(0);
                }
                for (ProxiedPlayer proxiedPlayer : players) {
                    proxiedPlayer.disconnect((BaseComponent)new TextComponent(msg));
                }
                break;
            }
            case BUNGEECOMMAND: {
                if (packet.getObject() == null) break;
                if ((Long)packet.getSetObject() > 0L) {
                    void var7_72;
                    int multiplier = 1;
                    String[] messages = (String[])packet.getObject();
                    int n = messages.length;
                    boolean bl = false;
                    while (var7_72 < n) {
                        String command = messages[var7_72];
                        if (command.startsWith("/")) {
                            command = command.substring(1);
                        }
                        final String intoRunnable = command;
                        ProxyServer.getInstance().getScheduler().schedule((Plugin)Skungee.getInstance(), new Runnable(){

                            @Override
                            public void run() {
                                ProxyServer.getInstance().getPluginManager().dispatchCommand(ProxyServer.getInstance().getConsole(), intoRunnable);
                            }
                        }, (Long)packet.getSetObject() * (long)multiplier, TimeUnit.MILLISECONDS);
                        ++multiplier;
                        ++var7_72;
                    }
                } else {
                    void var6_44;
                    String[] multiplier = (String[])packet.getObject();
                    int messages = multiplier.length;
                    boolean bl = false;
                    while (var6_44 < messages) {
                        void var7_76;
                        String string = multiplier[var6_44];
                        if (string.startsWith("/")) {
                            String string2 = string.substring(1);
                        }
                        ProxyServer.getInstance().getPluginManager().dispatchCommand(ProxyServer.getInstance().getConsole(), (String)var7_76);
                        ++var6_44;
                    }
                }
                break;
            }
            case SERVERPLAYERS: {
                void var7_78;
                if (packet.getObject() == null) break;
                HashSet<SkungeePlayer> skungeePlayers = new HashSet<SkungeePlayer>();
                String[] messages = (String[])packet.getObject();
                int n = messages.length;
                boolean bl = false;
                while (var7_78 < n) {
                    String server = messages[var7_78];
                    if (ProxyServer.getInstance().getServerInfo(server) != null) {
                        for (ProxiedPlayer player : ProxyServer.getInstance().getServerInfo(server).getPlayers()) {
                            skungeePlayers.add(new SkungeePlayer(false, player.getUniqueId(), player.getName()));
                        }
                    }
                    ++var7_78;
                }
                return skungeePlayers;
            }
            case SERVERIP: {
                void var7_80;
                if (packet.getObject() == null) break;
                HashSet<String> addresses = new HashSet<String>();
                String[] messages = (String[])packet.getObject();
                int n = messages.length;
                boolean bl = false;
                while (var7_80 < n) {
                    String server = messages[var7_80];
                    ServerInfo serverAddress = ProxyServer.getInstance().getServerInfo(server);
                    if (serverAddress != null) {
                        addresses.add(serverAddress.getAddress().getHostName());
                    }
                    ++var7_80;
                }
                return addresses;
            }
            case SERVERMOTD: {
                void var7_82;
                if (packet.getObject() == null) break;
                HashSet<String> motds = new HashSet<String>();
                String[] messages = (String[])packet.getObject();
                int n = messages.length;
                boolean bl = false;
                while (var7_82 < n) {
                    String server = messages[var7_82];
                    ServerInfo serverMotd = ProxyServer.getInstance().getServerInfo(server);
                    if (serverMotd != null) {
                        motds.add(serverMotd.getMotd());
                    }
                    ++var7_82;
                }
                return motds;
            }
            case PLAYERDISPLAYNAME: {
                if (players.isEmpty()) break;
                HashSet<String> names = new HashSet<String>();
                for (ProxiedPlayer proxiedPlayer : players) {
                    names.add(proxiedPlayer.getDisplayName());
                    if (packet.getObject() == null || packet.getChangeMode() == null) continue;
                    switch (packet.getChangeMode()) {
                        case SET: 
                        case ADD: {
                            proxiedPlayer.setDisplayName((String)packet.getObject());
                            break;
                        }
                        case DELETE: 
                        case REMOVE: 
                        case REMOVE_ALL: 
                        case RESET: {
                            proxiedPlayer.setDisplayName((String)packet.getObject());
                        }
                    }
                }
                return names;
            }
            case MAXPLAYERS: {
                void var7_84;
                if (packet.getObject() == null) break;
                HashSet<Integer> limits = new HashSet<Integer>();
                String[] messages = (String[])packet.getObject();
                int n = messages.length;
                boolean bl = false;
                while (var7_84 < n) {
                    String server = messages[var7_84];
                    for (ConnectedServer serverMax : ServerTracker.get(server)) {
                        if (serverMax == null || !ServerTracker.isResponding(serverMax).booleanValue()) continue;
                        limits.add(serverMax.getMaxPlayers());
                    }
                    ++var7_84;
                }
                return limits;
            }
            case ISSERVERONLINE: {
                if (packet.getObject() != null) {
                    void var6_52;
                    if (packet.getObject() instanceof String) {
                        ConnectedServer[] checkServers = ServerTracker.get((String)packet.getObject());
                        return checkServers != null && ServerTracker.isResponding(checkServers[0]) != false;
                    }
                    ArrayList<Boolean> list = new ArrayList<Boolean>();
                    String[] array = (String[])packet.getObject();
                    boolean bl = false;
                    while (var6_52 < array.length) {
                        ConnectedServer[] connectedServerArray = ServerTracker.get(array[var6_52]);
                        list.add(connectedServerArray != null && ServerTracker.isResponding(connectedServerArray[0]) != false);
                        ++var6_52;
                    }
                    return list.isEmpty() ? null : list;
                }
                return false;
            }
            case WHITELISTED: {
                void var7_88;
                if (packet.getObject() == null) break;
                HashSet<SkungeePlayer> whitelistedPlayers = new HashSet<SkungeePlayer>();
                String[] array = (String[])packet.getObject();
                int n = array.length;
                boolean bl = false;
                while (var7_88 < n) {
                    String server = array[var7_88];
                    for (ConnectedServer serverWhitelisted : ServerTracker.get(server)) {
                        if (serverWhitelisted == null || !ServerTracker.isResponding(serverWhitelisted).booleanValue()) continue;
                        whitelistedPlayers.addAll(serverWhitelisted.getWhitelistedPlayers());
                    }
                    ++var7_88;
                }
                return whitelistedPlayers;
            }
            case PLAYERCHATMODE: {
                if (players.isEmpty()) break;
                HashSet<SkungeeEnums.ChatMode> modes = new HashSet<SkungeeEnums.ChatMode>();
                for (ProxiedPlayer proxiedPlayer : players) {
                    SkungeeEnums.ChatMode chatMode = Utils.getEnum(SkungeeEnums.ChatMode.class, proxiedPlayer.getChatMode().toString());
                    if (chatMode == null) continue;
                    modes.add(chatMode);
                }
                return modes;
            }
            case PLAYERHANDSETTING: {
                if (players.isEmpty()) break;
                HashSet<SkungeeEnums.HandSetting> settings = new HashSet<SkungeeEnums.HandSetting>();
                for (ProxiedPlayer proxiedPlayer : players) {
                    SkungeeEnums.HandSetting handSetting = Utils.getEnum(SkungeeEnums.HandSetting.class, proxiedPlayer.getMainHand().toString());
                    if (handSetting == null) continue;
                    settings.add(handSetting);
                }
                return settings;
            }
            case PLAYERRECONNECTSERVER: {
                if (players.isEmpty()) break;
                HashSet<String> reconnected = new HashSet<String>();
                for (ProxiedPlayer proxiedPlayer : players) {
                    reconnected.add(proxiedPlayer.getReconnectServer().getName());
                    if (packet.getObject() == null || packet.getChangeMode() == null || packet.getChangeMode() != SkungeeEnums.SkriptChangeMode.SET) continue;
                    proxiedPlayer.setReconnectServer(ProxyServer.getInstance().getServerInfo((String)packet.getObject()));
                }
                return reconnected;
            }
            case PLAYERHASPERMISSIONS: {
                if (packet.getObject() != null && players != null) {
                    void var6_61;
                    if (players.isEmpty()) {
                        return false;
                    }
                    String[] reconnected = (String[])packet.getObject();
                    int array = reconnected.length;
                    boolean bl = false;
                    while (var6_61 < array) {
                        String string = reconnected[var6_61];
                        if (!((ProxiedPlayer)players.get(0)).hasPermission(string)) {
                            return false;
                        }
                        ++var6_61;
                    }
                } else {
                    return false;
                }
                return true;
            }
            case PLAYERCOMMAND: {
                HashSet<Boolean> registered = new HashSet<Boolean>();
                if (!players.isEmpty() && packet.getObject() != null) {
                    for (ProxiedPlayer proxiedPlayer : players) {
                        for (String command : (String[])packet.getObject()) {
                            registered.add(ProxyServer.getInstance().getPluginManager().dispatchCommand((CommandSender)proxiedPlayer, command));
                        }
                    }
                }
                return registered != null && !registered.isEmpty() ? registered : null;
            }
            case REDISPLAYERS: {
                HashSet<SkungeePlayer> redisPlayers = new HashSet<SkungeePlayer>();
                for (UUID uUID : RedisBungee.getApi().getPlayersOnline()) {
                    redisPlayers.add(new SkungeePlayer(false, uUID, ProxyServer.getInstance().getPlayer(uUID).getName()));
                }
                return redisPlayers != null && !redisPlayers.isEmpty() ? redisPlayers : null;
            }
            case REDISPROXYPLAYERS: {
                if (packet.getObject() == null) {
                    return null;
                }
                HashSet<SkungeePlayer> hashSet = new HashSet<SkungeePlayer>();
                for (String server : (String[])packet.getObject()) {
                    for (UUID uuid : RedisBungee.getApi().getPlayersOnProxy(server)) {
                        hashSet.add(new SkungeePlayer(false, uuid, ProxyServer.getInstance().getPlayer(uuid).getName()));
                    }
                }
                return hashSet != null && !hashSet.isEmpty() ? hashSet : null;
            }
            case REDISSERVERPLAYERS: {
                if (packet.getObject() == null) {
                    return null;
                }
                HashSet<SkungeePlayer> hashSet = new HashSet<SkungeePlayer>();
                for (String server : (String[])packet.getObject()) {
                    for (UUID uuid : RedisBungee.getApi().getPlayersOnServer(server)) {
                        hashSet.add(new SkungeePlayer(false, uuid, ProxyServer.getInstance().getPlayer(uuid).getName()));
                    }
                }
                return hashSet != null && !hashSet.isEmpty() ? hashSet : null;
            }
            case REDISPROXYCOMMAND: {
                if (packet.getObject() == null) {
                    return null;
                }
                for (String command : (String[])packet.getObject()) {
                    if (packet.getSetObject() != null) {
                        for (String server : (String[])packet.getSetObject()) {
                            RedisBungee.getApi().sendProxyCommand(server, command);
                        }
                        continue;
                    }
                    RedisBungee.getApi().sendProxyCommand(command);
                }
                break;
            }
            case REDISPLAYERNAME: {
                if (packet.getObject() == null || players.isEmpty()) {
                    return null;
                }
                HashSet<SkungeePlayer> names = new HashSet<SkungeePlayer>();
                for (ProxiedPlayer player : players) {
                    names.add(new SkungeePlayer(false, player.getUniqueId(), RedisBungee.getApi().getNameFromUuid(player.getUniqueId(), true)));
                }
                return names != null && !names.isEmpty() ? names : null;
            }
            case REDISISPLAYERONLINE: {
                if (players.isEmpty()) {
                    return false;
                }
                return players != null && RedisBungee.getApi().isPlayerOnline(((ProxiedPlayer)players.get(0)).getUniqueId());
            }
            case REDISLASTLOGIN: {
                if (packet.getObject() == null || players.isEmpty()) {
                    return null;
                }
                HashSet<Long> logins = new HashSet<Long>();
                for (ProxiedPlayer player : players) {
                    logins.add(RedisBungee.getApi().getLastOnline(player.getUniqueId()));
                }
                return logins != null && !logins.isEmpty() ? logins : null;
            }
            case REDISPLAYERID: {
                if (packet.getObject() == null || players.isEmpty()) {
                    return null;
                }
                HashSet<String> IDS = new HashSet<String>();
                for (ProxiedPlayer player : players) {
                    IDS.add(RedisBungee.getApi().getProxy(player.getUniqueId()));
                }
                return IDS != null && !IDS.isEmpty() ? IDS : null;
            }
            case REDISPLAYERSERVER: {
                if (packet.getObject() == null || players.isEmpty()) {
                    return null;
                }
                HashSet<String> redisservers = new HashSet<String>();
                for (ProxiedPlayer player : players) {
                    redisservers.add(RedisBungee.getApi().getServerFor(player.getUniqueId()).getName());
                }
                return redisservers != null && !redisservers.isEmpty() ? redisservers : null;
            }
            case REDISPLAYERIP: {
                if (packet.getObject() == null || players.isEmpty()) {
                    return null;
                }
                HashSet<String> IPS = new HashSet<String>();
                for (ProxiedPlayer player : players) {
                    IPS.add(RedisBungee.getApi().getPlayerIp(player.getUniqueId()).getHostName());
                }
                return IPS != null && !IPS.isEmpty() ? IPS : null;
            }
            case ISPLAYERONLINE: {
                if (players.isEmpty()) {
                    return false;
                }
                return players != null && ((ProxiedPlayer)players.get(0)).isConnected();
            }
            case ISUSINGFORGE: {
                if (players.isEmpty()) {
                    return false;
                }
                return players != null && ((ProxiedPlayer)players.get(0)).isForgeUser();
            }
            case PLAYERCOLOURS: {
                if (players.isEmpty()) {
                    return false;
                }
                return players != null && ((ProxiedPlayer)players.get(0)).hasChatColors();
            }
            case DISCONNECT: {
                if (packet.getObject() == null) break;
                ServerTracker.notResponding(ServerTracker.getByAddress(address, (Integer)packet.getObject()));
                break;
            }
            case CREATESERVER: {
                if (packet.getObject() == null || packet.getSetObject() == null) break;
                ServerInstancesSockets.send(new ServerInstancesPacket(false, ServerInstancesPacketType.CREATESERVER, packet.getObject(), packet.getSetObject()));
                break;
            }
            case SKUNGEEMESSAGES: {
                if (packet.getObject() == null || packet.getSetObject() == null) {
                    return null;
                }
                String[] messages = (String[])packet.getObject();
                String[] channels = (String[])packet.getSetObject();
                BungeeSockets.sendAll(new BungeePacket(false, BungeePacketType.SKUNGEEMESSAGES, (Object)messages, channels));
                break;
            }
            case TABHEADERFOOTER: {
                if (players.isEmpty() || packet.getObject() == null) break;
                TextComponent component = new TextComponent();
                for (String string : (String[])packet.getObject()) {
                    component.addExtra(string);
                }
                for (ProxiedPlayer player : players) {
                    if (player == null) continue;
                    if (packet.getSetObject() instanceof Integer) {
                        int pattern = (Integer)packet.getSetObject();
                        if (pattern == 1) {
                            player.setTabHeader((BaseComponent)component, (BaseComponent)new TextComponent());
                            continue;
                        }
                        if (pattern == 2) {
                            player.setTabHeader((BaseComponent)new TextComponent(), (BaseComponent)component);
                            continue;
                        }
                        player.setTabHeader((BaseComponent)component, (BaseComponent)component);
                        continue;
                    }
                    TextComponent secondary = new TextComponent();
                    for (String text : (String[])packet.getSetObject()) {
                        secondary.addExtra(text);
                    }
                    player.setTabHeader((BaseComponent)component, (BaseComponent)secondary);
                }
                break;
            }
            case PLAYERPERMISSIONS: {
                if (players.isEmpty()) break;
                if (packet.getObject() != null && packet.getChangeMode() != null) {
                    HashSet<String> permissions = new HashSet<String>();
                    for (Object object : (Object[])packet.getObject()) {
                        if (!(object instanceof String)) continue;
                        permissions.add((String)object);
                    }
                    block104: for (ProxiedPlayer player : players) {
                        switch (packet.getChangeMode()) {
                            case SET: {
                                for (String string : player.getPermissions()) {
                                    player.setPermission(string, false);
                                }
                            }
                            case ADD: {
                                for (String string : permissions) {
                                    player.setPermission(string, true);
                                }
                                continue block104;
                            }
                            case DELETE: 
                            case RESET: {
                                for (String string : player.getPermissions()) {
                                    player.setPermission(string, false);
                                }
                                continue block104;
                            }
                            case REMOVE: 
                            case REMOVE_ALL: {
                                for (String string : permissions) {
                                    player.setPermission(string, false);
                                }
                                break;
                            }
                        }
                    }
                    break;
                }
                HashSet permissions = new HashSet();
                for (ProxiedPlayer player : players) {
                    permissions.addAll(player.getPermissions());
                }
                return permissions;
            }
            case PLAYERGROUPS: {
                if (players.isEmpty()) break;
                if (packet.getObject() != null && packet.getChangeMode() != null) {
                    void var19_207;
                    String[] groups = new String[((Object[])packet.getObject()).length];
                    int i = 0;
                    Object[] player = (Object[])packet.getObject();
                    int secondary = player.length;
                    boolean bl = false;
                    while (var19_207 < secondary) {
                        Object object = player[var19_207];
                        if (object instanceof String) {
                            groups[i] = (String)object;
                        }
                        ++var19_207;
                    }
                    for (ProxiedPlayer player2 : players) {
                        Collection collection = player2.getGroups();
                        switch (packet.getChangeMode()) {
                            case SET: {
                                player2.removeGroups(collection.toArray(new String[collection.size()]));
                            }
                            case ADD: {
                                player2.addGroups(groups);
                                break;
                            }
                            case DELETE: 
                            case RESET: {
                                player2.removeGroups(collection.toArray(new String[collection.size()]));
                                break;
                            }
                            case REMOVE: 
                            case REMOVE_ALL: {
                                player2.removeGroups(groups);
                            }
                        }
                    }
                    break;
                }
                HashSet groups = new HashSet();
                for (ProxiedPlayer player : players) {
                    groups.addAll(player.getGroups());
                }
                return groups;
            }
            case UNREGISTERCOMMANDS: {
                if (packet.getObject() == null) break;
                for (String name : (String[])packet.getObject()) {
                    PluginManager pluginManager = ProxyServer.getInstance().getPluginManager();
                    Plugin plugin = pluginManager.getPlugin(name);
                    if (plugin == null || name.equalsIgnoreCase("skungee")) continue;
                    pluginManager.unregisterCommands(plugin);
                }
                break;
            }
            case UNREGISTERLISTENERS: {
                if (packet.getObject() == null) break;
                for (String name : (String[])packet.getObject()) {
                    PluginManager pluginManager = ProxyServer.getInstance().getPluginManager();
                    Plugin plugin = pluginManager.getPlugin(name);
                    if (plugin == null || name.equalsIgnoreCase("skungee")) continue;
                    pluginManager.unregisterListeners(plugin);
                }
                break;
            }
            case SHUTDOWNSERVER: {
                void var19_212;
                if (packet.getObject() == null) break;
                ServerInstancesPacket unload = new ServerInstancesPacket(false, ServerInstancesPacketType.SHUTDOWN, (String[])packet.getObject());
                if (packet.getSetObject() != null) {
                    unload = new ServerInstancesPacket(false, ServerInstancesPacketType.SHUTDOWN, packet.getObject(), packet.getSetObject());
                }
                ServerInstancesSockets.send(unload);
                BungeePacket shutdown = new BungeePacket(false, BungeePacketType.SHUTDOWN, new SkungeePlayer[0]);
                String[] stringArray = (String[])packet.getObject();
                int n = stringArray.length;
                boolean bl = false;
                while (var19_212 < n) {
                    String server = stringArray[var19_212];
                    BungeeSockets.send(shutdown, ServerTracker.get(server));
                    ++var19_212;
                }
                break;
            }
            case SERVERINSTANCES: {
                return ServerInstancesSockets.send(new ServerInstancesPacket(true, ServerInstancesPacketType.SERVERINSTANCES));
            }
            case REDISSERVERS: {
                return RedisBungee.getApi().getAllServers();
            }
            case REDISSERVERID: {
                return RedisBungee.getApi().getServerId();
            }
            case BUNGEEVERSION: {
                return ProxyServer.getInstance().getVersion();
            }
            case CURRENTSERVER: {
                return ServerTracker.getByAddress(address, (Integer)packet.getObject()) != null ? ServerTracker.getByAddress(address, (Integer)packet.getObject()).getName() : null;
            }
            case DISABLEDCOMMANDS: {
                return ProxyServer.getInstance().getDisabledCommands();
            }
            case BUNGEENAME: {
                return ProxyServer.getInstance().getName();
            }
            case PLUGINS: {
                return ProxyServer.getInstance().getPluginManager().getPlugins();
            }
            case BUNGEEPLAYERLIMIT: {
                return ProxyServer.getInstance().getConfig().getPlayerLimit();
            }
            case BUNGEETHROTTLE: {
                return ProxyServer.getInstance().getConfig().getThrottle();
            }
            case BUNGEETIMEOUT: {
                return ProxyServer.getInstance().getConfig().getTimeout();
            }
            case BUNGEEONLINEMODE: {
                return ProxyServer.getInstance().getConfig().isOnlineMode();
            }
        }
        return null;
    }
}

