/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import me.limeglass.skungee.bungeecord.Skungee;

public class EncryptionUtil {
    private Skungee bungeeInstance;
    private String algorithm = "AES/CTS/PKCS5Padding";
    private Boolean spigot;
    private Boolean printErrors;
    private me.limeglass.skungee.spigot.Skungee spigotInstance;

    public EncryptionUtil(Skungee skungee, Boolean spigot) {
        this.bungeeInstance = skungee;
        this.spigot = spigot;
        if (spigot.booleanValue()) {
            this.algorithm = me.limeglass.skungee.spigot.Skungee.getInstance().getConfig().getString("security.encryption.cipherAlgorithm", "AES/CTS/PKCS5Padding");
            this.printErrors = me.limeglass.skungee.spigot.Skungee.getInstance().getConfig().getBoolean("security.encryption.printEncryptionErrors", true);
        } else {
            this.algorithm = Skungee.getConfig().getString("security.encryption.cipherAlgorithm", "AES/CTS/PKCS5Padding");
            this.printErrors = Skungee.getConfig().getBoolean("security.encryption.printEncryptionErrors", true);
        }
    }

    public EncryptionUtil(me.limeglass.skungee.spigot.Skungee skungee, Boolean spigot) {
        this.spigotInstance = skungee;
        this.spigot = spigot;
        if (spigot.booleanValue()) {
            this.algorithm = me.limeglass.skungee.spigot.Skungee.getInstance().getConfig().getString("security.encryption.cipherAlgorithm", "AES/CTS/PKCS5Padding");
            this.printErrors = me.limeglass.skungee.spigot.Skungee.getInstance().getConfig().getBoolean("security.encryption.printEncryptionErrors", true);
        } else {
            this.algorithm = Skungee.getConfig().getString("security.encryption.cipherAlgorithm", "AES/CTS/PKCS5Padding");
            this.printErrors = Skungee.getConfig().getBoolean("security.encryption.printEncryptionErrors", true);
        }
    }

    public final void hashFile() {
        if (this.spigot.booleanValue()) {
            if (me.limeglass.skungee.spigot.Skungee.getInstance().getConfig().getBoolean("security.password.enabled", false) && me.limeglass.skungee.spigot.Skungee.getInstance().getConfig().getBoolean("security.password.hash", true) && me.limeglass.skungee.spigot.Skungee.getInstance().getConfig().getBoolean("security.password.hashFile", false) && !me.limeglass.skungee.spigot.Skungee.getInstance().getConfig().getString("security.password.password").equals("hashed")) {
                try {
                    File hashedFile = new File(me.limeglass.skungee.spigot.Skungee.getInstance().getDataFolder(), "hashed.txt");
                    if (!hashedFile.exists()) {
                        hashedFile.createNewFile();
                    } else {
                        hashedFile.delete();
                    }
                    FileOutputStream out = new FileOutputStream(hashedFile);
                    out.write(this.hash());
                    out.close();
                    me.limeglass.skungee.spigot.Skungee.consoleMessage("You're now safe to set the `password` option to \"hashed\"");
                }
                catch (IOException e) {
                    this.exception(e, "There was an error writting the hash to file.");
                }
            }
            if (this.isFileHashed().booleanValue()) {
                me.limeglass.skungee.spigot.Skungee.infoMessage("Password is successfully hashed to file!");
            }
        } else {
            if (Skungee.getConfig().getBoolean("security.password.enabled", false) && Skungee.getConfig().getBoolean("security.password.hash", true) && Skungee.getConfig().getBoolean("security.password.hashFile", false) && !Skungee.getConfig().getString("security.password.password").equals("hashed")) {
                try {
                    File hashedFile = new File(Skungee.getInstance().getDataFolder(), "hashed.txt");
                    if (!hashedFile.exists()) {
                        hashedFile.createNewFile();
                    } else {
                        hashedFile.delete();
                    }
                    FileOutputStream out = new FileOutputStream(hashedFile);
                    out.write(this.hash());
                    out.close();
                    Skungee.consoleMessage("You're now safe to set the `password` option to \"hashed\"");
                }
                catch (IOException e) {
                    this.exception(e, "There was an error writting the hash to file.");
                }
            }
            if (this.isFileHashed().booleanValue()) {
                Skungee.infoMessage("Password is successfully hashed to file!");
            }
        }
    }

    public final Boolean isFileHashed() {
        if (this.spigot.booleanValue()) {
            return me.limeglass.skungee.spigot.Skungee.getInstance().getConfig().getBoolean("security.password.enabled", false) && me.limeglass.skungee.spigot.Skungee.getInstance().getConfig().getBoolean("security.password.hash", true) && me.limeglass.skungee.spigot.Skungee.getInstance().getConfig().getBoolean("security.password.hashFile", false) && me.limeglass.skungee.spigot.Skungee.getInstance().getConfig().getString("security.password.password").equals("hashed") && this.getHashFromFile() != null;
        }
        return Skungee.getConfig().getBoolean("security.password.enabled", false) && Skungee.getConfig().getBoolean("security.password.hash", true) && Skungee.getConfig().getBoolean("security.password.hashFile", false) && Skungee.getConfig().getString("security.password.password").equals("hashed") && this.getHashFromFile() != null;
    }

    public final byte[] getHashFromFile() {
        File hashedFile = this.spigot != false ? new File(me.limeglass.skungee.spigot.Skungee.getInstance().getDataFolder(), "hashed.txt") : new File(Skungee.getInstance().getDataFolder(), "hashed.txt");
        try {
            return Files.readAllBytes(hashedFile.toPath());
        }
        catch (IOException e) {
            this.exception(e, "There was an error reading the hash from file.");
            return null;
        }
    }

    public final byte[] hash() {
        if (this.spigot.booleanValue()) {
            try {
                byte[] base64 = Base64.getEncoder().encode(me.limeglass.skungee.spigot.Skungee.getInstance().getConfig().getString("security.password.password").getBytes(StandardCharsets.UTF_8));
                return MessageDigest.getInstance(me.limeglass.skungee.spigot.Skungee.getInstance().getConfig().getString("security.password.hashAlgorithm", "SHA-256")).digest(base64);
            }
            catch (NoSuchAlgorithmException e) {
                this.exception(e, "The algorithm `" + this.algorithm + "` does not exist for your system. Please use a different algorithm.");
            }
        } else {
            try {
                byte[] base64 = Base64.getEncoder().encode(Skungee.getConfig().getString("security.password.password").getBytes(StandardCharsets.UTF_8));
                return MessageDigest.getInstance(Skungee.getConfig().getString("security.password.hashAlgorithm", "SHA-256")).digest(base64);
            }
            catch (NoSuchAlgorithmException e) {
                this.exception(e, "The algorithm `" + this.algorithm + "` does not exist for your system. Please use a different algorithm.");
            }
        }
        return null;
    }

    public byte[] encrypt(String keyString, String algorithm, byte[] packet) {
        block4: {
            try {
                byte[] serializedKey = keyString.getBytes(Charset.forName("UTF-8"));
                if (serializedKey.length != 16) {
                    me.limeglass.skungee.spigot.Skungee.infoMessage("The cipher key length is invalid. The length needs to be 16 but was: " + serializedKey.length);
                    return null;
                }
                SecretKeySpec key = new SecretKeySpec(serializedKey, "AES");
                Cipher cipher = Cipher.getInstance(algorithm);
                cipher.init(1, (Key)key, new IvParameterSpec(new byte[16]));
                return Base64.getEncoder().encode(cipher.doFinal(packet));
            }
            catch (NoSuchAlgorithmException e) {
                this.exception(e, "The algorithm `" + algorithm + "` does not exist for your system. Please use a different algorithm.");
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                if (!this.printErrors.booleanValue()) break block4;
                this.exception(e, "There was an error encrypting.");
            }
        }
        return null;
    }

    public Object decrypt(String keyString, String algorithm, byte[] input) {
        block4: {
            try {
                byte[] serializedKey = keyString.getBytes(Charset.forName("UTF-8"));
                if (serializedKey.length != 16) {
                    me.limeglass.skungee.spigot.Skungee.exception(new IllegalArgumentException(), "Invalid key size.");
                }
                SecretKeySpec key = new SecretKeySpec(serializedKey, "AES");
                Cipher cipher = Cipher.getInstance(algorithm);
                cipher.init(2, (Key)key, new IvParameterSpec(new byte[16]));
                byte[] decoded = Base64.getDecoder().decode(input);
                return this.deserialize(cipher.doFinal(decoded));
            }
            catch (NoSuchAlgorithmException e) {
                this.exception(e, "The algorithm `" + algorithm + "` does not exist for your system. Please use a different algorithm.");
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                if (!this.printErrors.booleanValue()) break block4;
                this.exception(e, "There was an error decrypting.");
            }
        }
        return null;
    }

    public byte[] serialize(Object object) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = new ObjectOutputStream(out);
            outputStream.writeObject(object);
            return out.toByteArray();
        }
        catch (IOException e) {
            this.exception(e, "Error happened when serializing.");
            return null;
        }
    }

    public Object deserialize(byte[] input) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(input);
            ObjectInputStream inputStream = new ObjectInputStream(in);
            return inputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            this.exception(e, "Error happened when deserializing.");
            return null;
        }
    }

    public Boolean isSpigot() {
        return this.spigot;
    }

    public Skungee getBungeeInstance() {
        return this.bungeeInstance;
    }

    public me.limeglass.skungee.spigot.Skungee getSpigotInstance() {
        return this.spigotInstance;
    }

    private void exception(Throwable e, String reason) {
        if (this.spigot.booleanValue()) {
            me.limeglass.skungee.spigot.Skungee.exception(e, reason);
        } else {
            Skungee.exception(e, reason);
        }
    }
}

