/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.util.Timespan;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import me.limeglass.skungee.objects.SkungeeTitle;
import me.limeglass.skungee.spigot.lang.SkungeePropertyExpression;
import me.limeglass.skungee.spigot.utils.annotations.AllChangers;
import me.limeglass.skungee.spigot.utils.annotations.Properties;
import me.limeglass.skungee.spigot.utils.annotations.PropertiesAddition;
import org.bukkit.event.Event;

@Name(value="Bungeecord title time")
@Description(value={"Returns the time(s) of defined skungee title(s)."})
@Properties(value={"skungeetitles", "[stay] time[s]", "{1}[(all [[of] the]|the)]"})
@PropertiesAddition(value="[(skungee|bungee[[ ]cord])] title[s]")
@AllChangers
public class ExprBungeeTitleTime
extends SkungeePropertyExpression<SkungeeTitle, Timespan> {
    private Map<SkungeeTitle, Timespan> getTimespans(SkungeeTitle[] titles) {
        HashMap<SkungeeTitle, Timespan> times = new HashMap<SkungeeTitle, Timespan>();
        for (SkungeeTitle title : titles) {
            times.put(title, new Timespan((long)title.getStay()));
        }
        return times;
    }

    protected Timespan[] get(Event event, SkungeeTitle[] titles) {
        if (this.isNull(event).booleanValue()) {
            return null;
        }
        Collection<Timespan> times = this.getTimespans(titles).values();
        return times != null ? times.toArray(new Timespan[times.size()]) : null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.isNull(event).booleanValue() || delta == null || mode == null) {
            return;
        }
        SkungeeTitle[] titles = this.expressions.getAll(event, SkungeeTitle.class);
        Map<SkungeeTitle, Timespan> times = this.getTimespans(titles);
        Timespan timespan = (Timespan)delta[0];
        switch (mode) {
            case ADD: {
                for (Map.Entry<SkungeeTitle, Timespan> entry : times.entrySet()) {
                    if (entry.getValue().getTicks_i() != timespan.getTicks_i()) continue;
                    entry.getKey().setStay((int)(entry.getValue().getTicks_i() + timespan.getTicks_i()));
                }
                break;
            }
            case REMOVE: {
                for (Map.Entry<SkungeeTitle, Timespan> entry : times.entrySet()) {
                    if (entry.getValue().getTicks_i() != timespan.getTicks_i()) continue;
                    entry.getKey().setStay((int)(entry.getValue().getTicks_i() - timespan.getTicks_i()));
                }
                break;
            }
            case DELETE: 
            case REMOVE_ALL: 
            case RESET: {
                for (SkungeeTitle title : titles) {
                    title.setStay(2);
                }
                break;
            }
            case SET: {
                for (SkungeeTitle title : titles) {
                    title.setStay((int)timespan.getTicks_i());
                }
                break;
            }
        }
    }
}

