/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import java.util.HashSet;
import me.limeglass.skungee.objects.SkungeeTitle;
import me.limeglass.skungee.spigot.lang.SkungeePropertyExpression;
import me.limeglass.skungee.spigot.utils.annotations.Changers;
import me.limeglass.skungee.spigot.utils.annotations.Properties;
import me.limeglass.skungee.spigot.utils.annotations.PropertiesAddition;
import org.bukkit.event.Event;

@Name(value="Bungeecord subtitle")
@Description(value={"Returns the subtitle(s) of defined skungee title(s)."})
@Properties(value={"skungeetitles", "sub[-]title[s]", "{1}[(all [[of] the]|the)]"})
@PropertiesAddition(value="[(skungee|bungee[[ ]cord])] title[s]")
@Changers(value={Changer.ChangeMode.SET, Changer.ChangeMode.DELETE, Changer.ChangeMode.REMOVE, Changer.ChangeMode.RESET})
public class ExprBungeeTitleSubtitle
extends SkungeePropertyExpression<SkungeeTitle, String> {
    protected String[] get(Event event, SkungeeTitle[] titles) {
        if (this.isNull(event).booleanValue()) {
            return null;
        }
        HashSet<String> subtitles = new HashSet<String>();
        for (SkungeeTitle title : titles) {
            subtitles.add(title.getSubtitleText());
        }
        return subtitles != null ? subtitles.toArray(new String[subtitles.size()]) : null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.isNull(event).booleanValue() || delta == null || mode == null) {
            return;
        }
        SkungeeTitle[] titles = this.expressions.getAll(event, SkungeeTitle.class);
        switch (mode) {
            case ADD: {
                break;
            }
            case DELETE: 
            case REMOVE: 
            case REMOVE_ALL: 
            case RESET: {
                for (SkungeeTitle title : titles) {
                    title.setSubtitle(null);
                }
                break;
            }
            case SET: {
                for (SkungeeTitle title : titles) {
                    title.setSubtitle((String)delta[0]);
                }
                break;
            }
        }
    }
}

