/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.skuared.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import fr.syst3ms.skuared.expressions.ExprLastResult;
import fr.syst3ms.skuared.util.Algorithms;
import fr.syst3ms.skuared.util.MathUtils;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.event.Event;

public class EffSigma
extends Effect {
    private static final ReentrantLock SKRIPT_EXECUTION = new ReentrantLock(true);
    private static final Field DELAYED;
    private static final ExecutorService threadPool;
    private Expression<String> mathExpression;
    private Expression<Number> lastNumber;
    private Expression<Number> start;
    private boolean isInfinite;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.mathExpression = exprs[0];
        this.isInfinite = matchedPattern == 1;
        this.start = exprs[1];
        if (!this.isInfinite) {
            this.lastNumber = exprs[2];
        }
        return true;
    }

    protected void execute(Event e) {
        String expr = (String)this.mathExpression.getSingle(e);
        Integer end = this.isInfinite ? (Number)-1 : (Number)((Number)this.lastNumber.getSingle(e));
        Number s = (Number)this.start.getSingle(e);
        if (expr == null || end == null || s == null) {
            return;
        }
        boolean useWolfram = this.isInfinite || end > Short.MAX_VALUE;
        CompletableFuture<String> request = CompletableFuture.supplyAsync(() -> useWolfram ? Algorithms.sendWolframApiRequest(String.format("sum %s,x=%s to %s", expr, this.start, this.isInfinite ? "infinity" : end)) : MathUtils.sigma(expr, s.longValue(), end.longValue()).toString(), threadPool);
        request.whenComplete((res, err) -> {
            if (err != null) {
                err.printStackTrace();
            }
            SKRIPT_EXECUTION.lock();
            try {
                if (res != null) {
                    ExprLastResult.lastResult = res;
                }
                if (this.getNext() != null) {
                    TriggerItem.walk((TriggerItem)this.getNext(), (Event)e);
                }
            }
            finally {
                SKRIPT_EXECUTION.unlock();
            }
        });
    }

    protected TriggerItem walk(Event e) {
        this.debug(e, true);
        this.delay(e);
        this.execute(e);
        return null;
    }

    private void delay(Event e) {
        if (DELAYED != null) {
            try {
                ((Set)DELAYED.get(null)).add(e);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "sum " + this.mathExpression.toString(e, debug) + " to " + (this.isInfinite ? "infinity" : this.lastNumber.toString(e, debug)) + " starting at " + this.start.toString(e, debug);
    }

    static {
        threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        Field _DELAYED = null;
        try {
            _DELAYED = Delay.class.getDeclaredField("delayed");
            _DELAYED.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            Skript.warning((String)"Skript's 'delayed' method could not be resolved. Some Skript warnings may not be available.");
        }
        DELAYED = _DELAYED;
        Skript.registerEffect(EffSigma.class, (String[])new String[]{"(sum|sigma) %string% from %number% to %number%", "(sum|sigma) %string% from %number% to infinity"});
    }
}

