/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.skuared.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.google.common.base.Strings;
import fr.syst3ms.skuared.util.Algorithms;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class ExprLevenshteinDistance
extends SimpleExpression<Number> {
    private Expression<String> first;
    private Expression<String> second;
    private boolean ignoreCase;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, @NotNull SkriptParser.ParseResult parseResult) {
        this.first = expressions[0];
        this.second = expressions[1];
        this.ignoreCase = parseResult.mark == 1;
        return true;
    }

    @NotNull
    protected Number[] get(Event event) {
        String f = Strings.nullToEmpty((String)((String)this.first.getSingle(event)));
        String s = Strings.nullToEmpty((String)((String)this.second.getSingle(event)));
        return new Number[]{Algorithms.levenshtein(f, s, this.ignoreCase)};
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Integer.class;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public String toString(Event event, boolean b) {
        return "levenshtein distance between " + this.first.toString(event, b) + " and " + this.second.toString(event, b) + (this.ignoreCase ? " ignoring case" : "");
    }

    static {
        Skript.registerExpression(ExprLevenshteinDistance.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"(levenshtein|string) distance between %string% and %string% [(1\u00c2\u00a6ignor(e|ing) case)]"});
    }
}

