/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skriptaddon.skriptplus.util.maps;

import com.w00tmast3r.skriptaddon.skriptplus.util.maps.MapColor;
import com.w00tmast3r.skriptaddon.skriptplus.util.maps.RenderTask;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class SkriptMapRenderer
extends MapRenderer
implements Listener {
    private final ArrayList<UUID> dirtyPlayers = new ArrayList();
    private ArrayList<RenderTask> tasks = new ArrayList();

    public SkriptMapRenderer() {
        super(false);
    }

    public void render(MapView mapView, MapCanvas mapCanvas, Player player) {
        UUID uuid = player.getUniqueId();
        if (this.dirtyPlayers.contains(uuid)) {
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    mapCanvas.setPixel(x, y, MapColor.TRANSPARENT.color());
                }
            }
            for (RenderTask r : this.tasks) {
                r.render(mapView, mapCanvas, player);
            }
            this.dirtyPlayers.remove(uuid);
        }
    }

    public void clearTasks() {
        this.tasks = new ArrayList();
        this.redraw();
    }

    public void update(RenderTask task) {
        this.tasks.add(task);
        this.redraw();
    }

    public void redraw() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (this.dirtyPlayers.contains(p.getUniqueId())) continue;
            this.dirtyPlayers.add(p.getUniqueId());
        }
    }

    public static void createHandle(MapView mapView, boolean overwrite) {
        if (mapView == null) {
            return;
        }
        if (overwrite && mapView.getRenderers() != null) {
            for (MapRenderer renderer : mapView.getRenderers()) {
                mapView.removeRenderer(renderer);
            }
        }
        mapView.addRenderer((MapRenderer)new SkriptMapRenderer());
    }

    public static SkriptMapRenderer getRenderer(MapView mapView) {
        if (mapView == null || mapView.getRenderers() == null) {
            return null;
        }
        for (MapRenderer renderer : mapView.getRenderers()) {
            if (!(renderer instanceof SkriptMapRenderer)) continue;
            return (SkriptMapRenderer)renderer;
        }
        return null;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.dirtyPlayers.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (!this.dirtyPlayers.contains(event.getPlayer().getUniqueId())) {
            this.dirtyPlayers.add(event.getPlayer().getUniqueId());
        }
    }
}

