/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skriptaddon.skriptplus.util.maps;

public enum MapColor {
    TRANSPARENT(0),
    GRASS(1),
    SAND(2),
    AMBIGUOUS_COLOR(3),
    RED(4),
    SKY_BLUE(5),
    GRAY(6),
    GREEN(7),
    WHITE(8),
    LIGHT_GRAY(9),
    LIGHT_BROWN(10),
    DARK_GRAY(11),
    BLUE(12),
    FADED_BROWN(13),
    FADED_WHITE(14),
    GENERAL_ORANGE(15),
    GENERAL_MAGENTA(16),
    GENERAL_LIGHT_BLUE(17),
    GENERAL_YELLOW(18),
    GENERAL_LIME(19),
    GENERAL_PINK(20),
    GENERAL_GRAY(21),
    GENERAL_LIGHT_GRAY(22),
    GENERAL_CYAN(23),
    GENERAL_PURPLE(24),
    GENERAL_BLUE(25),
    GENERAL_BROWN(26),
    GENERAL_GREEN(27),
    GENERAL_RED(28),
    GENERAL_BLACK(29),
    GOLD(30),
    DIAMOND_BLUE(31),
    LAPIS_BLUE(32),
    EMERALD_GREEN(33),
    OBSIDIAN_BLACK(34),
    COLOR_NETHER(35);

    private final byte baseColor;

    private MapColor(byte baseColor) {
        this.baseColor = baseColor;
    }

    public byte color() {
        return this.color(Variant.LIGHTEST);
    }

    public byte color(Variant shade) {
        return Variant.add(this, shade);
    }

    public String format() {
        return this.format(Variant.LIGHTEST);
    }

    public String format(Variant shade) {
        return "\u00a7" + String.valueOf(Variant.add(this, shade));
    }

    public static enum Variant {
        LIGHTEST(2),
        LIGHT(1),
        DARK(0),
        DARKEST(3);

        private final byte baseShift;

        private Variant(byte baseShift) {
            this.baseShift = baseShift;
        }

        public static byte add(MapColor color, Variant shade) {
            return (byte)(color.baseColor * 4 + shade.baseShift);
        }
    }
}

