/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skriptaddon.skriptplus.util;

import com.w00tmast3r.skriptaddon.skaddonlib.util.Collect;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginIdentifier<P extends JavaPlugin> {
    private final String type;
    private final Version version;
    private final P plugin;

    public PluginIdentifier(P instance) {
        String ver = instance.getDescription().getVersion();
        if (ver.contains("-")) {
            this.version = new Version(ver.split("-")[0]);
            this.type = ver.split("-")[1];
        } else {
            this.version = new Version(ver);
            this.type = "RELEASE";
        }
        this.plugin = instance;
    }

    public String getType() {
        return this.type;
    }

    public Version getVersion() {
        return this.version;
    }

    public P getPlugin() {
        return this.plugin;
    }

    public static class Version {
        private final Integer[] versions;

        public Version(String version) {
            String[] strings = version.split("\\.");
            Integer[] versions = new Integer[strings.length];
            for (int i = 0; i < versions.length; ++i) {
                versions[i] = Integer.parseInt(strings[i]);
            }
            this.versions = versions;
        }

        public int getMajor() {
            try {
                return this.versions[0];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return 0;
            }
        }

        public int getMinor() {
            try {
                return this.versions[1];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return 0;
            }
        }

        public int getRevision() {
            try {
                return this.versions[2];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return 0;
            }
        }

        public int getHierarchicalVersion(int version) {
            try {
                return this.versions[version];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return 0;
            }
        }

        public String toString() {
            return Collect.toString((Object[])this.versions, (char)'.', (boolean)false);
        }
    }
}

