/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skriptaddon.skriptplus.util;

import com.google.common.collect.Maps;
import com.w00tmast3r.skriptaddon.skriptplus.util.MidiUtil;
import com.w00tmast3r.skriptaddon.skriptplus.util.ToneUtil;
import java.util.Map;
import java.util.Set;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class NoteBlockReceiver
implements Receiver {
    private static final float VOLUME_RANGE = 10.0f;
    private final Set<Player> listeners;
    private final Map<Integer, Integer> channelPatches;

    public NoteBlockReceiver(Set<Player> listeners) {
        this.listeners = listeners;
        this.channelPatches = Maps.newHashMap();
    }

    @Override
    public void send(MidiMessage m, long time) {
        if (m instanceof ShortMessage) {
            ShortMessage smessage = (ShortMessage)m;
            int chan = smessage.getChannel();
            switch (smessage.getCommand()) {
                case 192: {
                    int patch = smessage.getData1();
                    this.channelPatches.put(chan, patch);
                    break;
                }
                case 144: {
                    this.playNote(smessage);
                    break;
                }
            }
        }
    }

    public void playNote(ShortMessage message) {
        if (144 != message.getCommand()) {
            return;
        }
        float pitch = (float)ToneUtil.midiToPitch(message);
        float volume = 10.0f * ((float)message.getData2() / 127.0f);
        Integer patch = this.channelPatches.get(message.getChannel());
        Sound instrument = Sound.NOTE_PIANO;
        if (patch != null) {
            instrument = MidiUtil.patchToInstrument(patch);
        }
        for (Player player : this.listeners) {
            player.playSound(player.getLocation(), instrument, volume, pitch);
        }
    }

    @Override
    public void close() {
        this.listeners.clear();
        this.channelPatches.clear();
    }
}

