/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skriptaddon.skriptplus.elements.virtualchests.v2;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skriptaddon.skaddonlib.development.Codename;
import com.w00tmast3r.skriptaddon.skaddonlib.development.ManualDoc;
import com.w00tmast3r.skriptaddon.skaddonlib.development.Patterns;
import com.w00tmast3r.skriptaddon.skriptplus.elements.virtualchests.v2.FormattedSlotManager;
import com.w00tmast3r.skriptaddon.skriptplus.elements.virtualchests.v2.SlotRule;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

@Codename(value="effVirtualChestV2ChangeSlot")
@Patterns(value={"format slot %number% of %players% with %itemstack% to close then run %string%", "format slot %number% of %players% with %itemstack% to run %string%", "format slot %number% of %players% with %itemstack% to close", "format slot %number% of %players% with %itemstack% to (be|act) unstealable", "unformat slot %number% of %players%"})
@ManualDoc(name="Format Item Menu V2", description="Format a single slot to act as an virtual menu. This only applies when the player has an open inventory.")
public class EffAddFormatSlot
extends Effect {
    private Expression<Number> slot;
    private Expression<Player> targets;
    private Expression<ItemStack> item;
    private Expression<String> callback;
    private int action;

    protected void execute(Event event) {
        SlotRule toClone;
        Number s = (Number)this.slot.getSingle(event);
        ItemStack i = null;
        if (s == null) {
            return;
        }
        switch (this.action) {
            case 0: {
                String c = (String)this.callback.getSingle(event);
                i = (ItemStack)this.item.getSingle(event);
                if (c == null) {
                    return;
                }
                toClone = new SlotRule(c, true);
                break;
            }
            case 1: {
                String c = (String)this.callback.getSingle(event);
                i = (ItemStack)this.item.getSingle(event);
                if (c == null) {
                    return;
                }
                toClone = new SlotRule(c, false);
                break;
            }
            case 2: {
                i = (ItemStack)this.item.getSingle(event);
                if (i == null) {
                    return;
                }
                toClone = new SlotRule(null, true);
                break;
            }
            case 3: {
                i = (ItemStack)this.item.getSingle(event);
                toClone = new SlotRule(null, false);
                break;
            }
            case 4: {
                for (Player p : (Player[])this.targets.getAll(event)) {
                    FormattedSlotManager.removeRule(p, s.intValue());
                }
                return;
            }
            default: {
                assert (false);
                return;
            }
        }
        if (i != null) {
            for (Player p : (Player[])this.targets.getAll(event)) {
                if (p.getOpenInventory().getType() == InventoryType.CRAFTING) continue;
                p.getOpenInventory().setItem(s.intValue(), i);
            }
        }
        for (Player p : (Player[])this.targets.getAll(event)) {
            if (p.getOpenInventory().getType() == InventoryType.CRAFTING) continue;
            FormattedSlotManager.addRule(p, s.intValue(), toClone.getCopy());
        }
    }

    public String toString(Event event, boolean b) {
        return "format";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.slot = expressions[0];
        this.targets = expressions[1];
        if (i <= 3) {
            this.item = expressions[2];
        }
        if (i <= 1) {
            this.callback = expressions[3];
        }
        this.action = i;
        return true;
    }
}

