/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skriptaddon.skriptplus.elements.expressions.classes;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skriptaddon.skaddonlib.development.Codename;
import com.w00tmast3r.skriptaddon.skaddonlib.development.Examples;
import com.w00tmast3r.skriptaddon.skaddonlib.development.ManualDoc;
import com.w00tmast3r.skriptaddon.skaddonlib.development.Patterns;
import com.w00tmast3r.skriptaddon.skriptplus.util.ArrayUtils;
import org.bukkit.event.Event;

@Codename(value="exprRegisteredEnumValues")
@Patterns(value={"[all ]enum values of %classinfo%"})
@ManualDoc(name="Enum Values", description="Returns a collection of strings that represent the enum values of a class. Keep in mind <classinfo> cannot be used in as a command argument.")
@Examples(value={"message \"%all enum values of particle%\""})
public class ExprValues
extends SimpleExpression<String> {
    Expression<ClassInfo> cInfo;

    protected String[] get(Event event) {
        ClassInfo c = (ClassInfo)this.cInfo.getSingle(event);
        return c.getC().isEnum() ? ArrayUtils.toFriendlyStringArray(c.getC().getEnumConstants()) : null;
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event event, boolean b) {
        return "enum values";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.cInfo = expressions[0];
        return true;
    }
}

