/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skriptaddon.skriptplus.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.w00tmast3r.skriptaddon.skaddonlib.development.Codename;
import com.w00tmast3r.skriptaddon.skaddonlib.development.ManualDoc;
import com.w00tmast3r.skriptaddon.skaddonlib.development.PropertyPatterns;
import com.w00tmast3r.skriptaddon.skaddonlib.util.Collect;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Codename(value="exprIsHealthScaled")
@PropertyPatterns(property="scaled health (state|ability|mode)", fromType="players")
@ManualDoc(name="Scaled Health State", description="A true/false expression representing whether or not a player is shown a scaled health.")
public class ExprHealthScaleMode
extends SimplePropertyExpression<Player, Boolean> {
    protected String getPropertyName() {
        return "scaled health state";
    }

    public Boolean convert(Player player) {
        return player.isHealthScaled();
    }

    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.SET) {
            return (Class[])Collect.asArray((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        boolean b = delta != null && (Boolean)delta[0] != false;
        switch (mode) {
            case SET: {
                for (Player p : (Player[])this.getExpr().getAll(e)) {
                    p.setHealthScaled(b);
                }
                break;
            }
            case RESET: {
                for (Player p : (Player[])this.getExpr().getAll(e)) {
                    p.setHealthScaled(false);
                }
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: 
            case DELETE: {
                assert (false);
                break;
            }
        }
    }
}

