/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skriptaddon.skriptplus.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.w00tmast3r.skriptaddon.skaddonlib.development.Codename;
import com.w00tmast3r.skriptaddon.skaddonlib.development.ManualDoc;
import com.w00tmast3r.skriptaddon.skaddonlib.development.PropertyPatterns;
import com.w00tmast3r.skriptaddon.skaddonlib.util.Collect;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Codename(value="exprHealthScale")
@PropertyPatterns(property="scaled health", fromType="players")
@ManualDoc(name="Scaled Health", description="The health scale a player is shown. Health scale determines how many hearts a player can see and can be used to increase max hp without altering heart count.")
public class ExprHealthScale
extends SimplePropertyExpression<Player, Number> {
    protected String getPropertyName() {
        return "scaled health";
    }

    public Number convert(Player player) {
        return player.getHealthScale();
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.SET) {
            return (Class[])Collect.asArray((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Integer n = delta[0] == null || ((Number)delta[0]).doubleValue() < 0.0 ? (Number)1 : (Number)((Number)delta[0]);
        switch (mode) {
            case SET: {
                for (Player p : (Player[])this.getExpr().getAll(e)) {
                    p.setHealthScale(((Number)n).doubleValue() * 2.0);
                }
                break;
            }
            case RESET: {
                for (Player p : (Player[])this.getExpr().getAll(e)) {
                    p.setHealthScaled(false);
                }
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: 
            case DELETE: {
                assert (false);
                break;
            }
        }
    }
}

