/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skriptaddon.skriptplus.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skriptaddon.skaddonlib.development.Codename;
import com.w00tmast3r.skriptaddon.skaddonlib.development.ManualDoc;
import com.w00tmast3r.skriptaddon.skaddonlib.development.Patterns;
import com.w00tmast3r.skriptaddon.skriptplus.util.maps.RenderTask;
import com.w00tmast3r.skriptaddon.skriptplus.util.maps.SkriptMapRenderer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapView;
import org.bukkit.map.MinecraftFont;

@Codename(value="effDrawCustomMapText")
@Patterns(value={"draw %string% on [map] %number%", "draw %string% on [map] %number% [starting] from %number%, %number%"})
@ManualDoc(name="Draw Text On Map", description="Draw text onto a map. If coordinates are not specified, the text will be drawn from the top left corner of the map canvas. Colors and new lines are not currently supported. Maps must be first initialized by the Manage Map effect.")
public class EffDrawText
extends Effect {
    private Expression<String> text;
    private Expression<Number> id;
    private Expression<Number> x;
    private Expression<Number> y;
    private boolean useCoordinates;

    protected void execute(Event event) {
        MapView mapView;
        final String i = (String)this.text.getSingle(event);
        Number n = (Number)this.id.getSingle(event);
        int xO = 0;
        int yO = 0;
        if (this.useCoordinates) {
            Number xC = (Number)this.x.getSingle(event);
            Number yC = (Number)this.y.getSingle(event);
            if (xC == null || yC == null) {
                return;
            }
            xO = xC.intValue();
            yO = yC.intValue();
        }
        if (n == null || i == null) {
            return;
        }
        short id = n.shortValue();
        final int fXO = xO;
        final int fYO = yO;
        try {
            mapView = Bukkit.getMap((short)id);
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("Map " + id + " has not been initialized yet!");
            return;
        }
        SkriptMapRenderer renderer = SkriptMapRenderer.getRenderer(mapView);
        if (renderer == null) {
            return;
        }
        renderer.update(new RenderTask(){

            @Override
            public void render(MapView mapView, MapCanvas mapCanvas, Player player) {
                mapCanvas.drawText(fXO, fYO, (MapFont)MinecraftFont.Font, i);
            }
        });
    }

    public String toString(Event event, boolean b) {
        return "manage skript maps";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.text = expressions[0];
        this.id = expressions[1];
        boolean bl = this.useCoordinates = i == 1;
        if (this.useCoordinates) {
            this.x = expressions[2];
            this.y = expressions[3];
        }
        return true;
    }
}

