/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skriptaddon.skriptplus.util.lib.legacy;

import com.w00tmast3r.skriptaddon.skriptplus.SkriptPlus;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class BossBarUtils {
    private static HashMap<String, FakeDragon> playerDragons = new HashMap();

    public static String getMessage(Player player) {
        FakeDragon dragon = BossBarUtils.getDragon(player);
        return dragon.getName();
    }

    public static void setMessage(Player player, String msg, boolean override) {
        if (BossBarUtils.hasBar(player) && !override) {
            return;
        }
        FakeDragon dragon = BossBarUtils.getDragon(player);
        if (msg.length() > 64) {
            msg = msg.substring(0, 63);
        }
        dragon.setName(msg);
    }

    public static float getHealth(Player player) {
        FakeDragon dragon = BossBarUtils.getDragon(player);
        return dragon.getHealth();
    }

    public static void setHealth(Player player, float health, boolean override) {
        if (BossBarUtils.hasBar(player) && !override) {
            return;
        }
        FakeDragon dragon = BossBarUtils.getDragon(player);
        dragon.setHealth(health);
    }

    public static void setPercent(Player player, float percent, boolean override) {
        if (BossBarUtils.hasBar(player) && !override) {
            return;
        }
        FakeDragon dragon = BossBarUtils.getDragon(player);
        float health = percent / 100.0f * 200.0f;
        dragon.setHealth(health);
    }

    public static void displayBar(final Player player, String msg, float percent, int seconds, boolean override) {
        BossBarUtils.setMessage(player, msg, override);
        BossBarUtils.setPercent(player, percent, override);
        new BukkitRunnable(){

            public void run() {
                BossBarUtils.removeBar(player);
            }
        }.runTaskLater(SkriptPlus.me, (long)(seconds * 20));
    }

    public static void displayLoadingBar(final Player player, String msg, final String endMsg, int seconds, final boolean loadUp, final boolean override) {
        BossBarUtils.setMessage(player, msg, override);
        BossBarUtils.setPercent(player, loadUp ? 0.0f : 100.0f, override);
        float changePerSecond = 200.0f / (float)seconds;
        final float changePerTick = changePerSecond / 20.0f;
        new BukkitRunnable(){

            public void run() {
                FakeDragon dragon = BossBarUtils.getDragon(player);
                if (loadUp ? dragon.getHealth() < 200.0f : dragon.getHealth() > 0.0f) {
                    if (loadUp) {
                        BossBarUtils.setHealth(player, BossBarUtils.getHealth(player) + changePerTick, override);
                    } else {
                        BossBarUtils.setHealth(player, BossBarUtils.getHealth(player) - changePerTick, override);
                    }
                } else {
                    BossBarUtils.setMessage(player, endMsg, override);
                    BossBarUtils.setPercent(player, 100.0f, override);
                    this.cancel();
                    new BukkitRunnable(){

                        public void run() {
                            BossBarUtils.removeBar(player);
                        }
                    }.runTaskLater(SkriptPlus.me, 40L);
                }
            }
        }.runTaskTimer(SkriptPlus.me, 0L, 1L);
    }

    public static void removeBar(Player player) {
        if (BossBarUtils.hasBar(player)) {
            FakeDragon dragon = BossBarUtils.getDragon(player);
            dragon.destroy();
            playerDragons.remove(player.getName());
        }
    }

    public static boolean hasBar(Player player) {
        return playerDragons.containsKey(player.getName());
    }

    public static FakeDragon getDragon(Player player) {
        if (BossBarUtils.hasBar(player)) {
            return playerDragons.get(player.getName());
        }
        FakeDragon dragon = new FakeDragon(player);
        dragon.setInvisible(true);
        playerDragons.put(player.getName(), dragon);
        return dragon;
    }

    public static class BarReflectionUtils {
        public static Object getNMSClass(String name, Object ... args) throws Exception {
            Class<?> c = Class.forName(BarReflectionUtils.getNMSPackageName() + "." + name);
            int params = 0;
            if (args != null) {
                params = args.length;
            }
            for (Constructor<?> co : c.getConstructors()) {
                if (co.getParameterTypes().length != params) continue;
                return co.newInstance(args);
            }
            return null;
        }

        public static Class<?> getNMSClassExact(String name, Object ... args) {
            Class<?> c;
            try {
                c = Class.forName(BarReflectionUtils.getNMSPackageName() + "." + name);
            }
            catch (Exception e) {
                return null;
            }
            return c;
        }

        public static Object getOBCClass(String name, Object ... args) throws Exception {
            Class<?> c = Class.forName(BarReflectionUtils.getOBCPackageName() + "." + name);
            int params = 0;
            if (args != null) {
                params = args.length;
            }
            for (Constructor<?> co : c.getConstructors()) {
                if (co.getParameterTypes().length != params) continue;
                return co.newInstance(args);
            }
            return null;
        }

        public static Class<?> getOBCClassExact(String name, Object ... args) {
            Class<?> c;
            try {
                c = Class.forName(BarReflectionUtils.getOBCPackageName() + "." + name);
            }
            catch (Exception e) {
                return null;
            }
            return c;
        }

        public static Method getMethod(String name, Class<?> c, int params) {
            for (Method m : c.getMethods()) {
                if (!m.getName().equals(name) || m.getParameterTypes().length != params) continue;
                return m;
            }
            return null;
        }

        public static Method getMethod(String name, Class<?> c) {
            for (Method m : c.getMethods()) {
                if (!m.getName().equals(name)) continue;
                return m;
            }
            return null;
        }

        public static Field getField(String name, Class<?> c) {
            for (Field f : c.getFields()) {
                if (!f.getName().equals(name)) continue;
                return f;
            }
            return null;
        }

        public static void setValue(Object instance, String fieldName, Object value) throws Exception {
            Field field = instance.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(instance, value);
        }

        public static String getNMSPackageName() {
            return "net.minecraft.server." + Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        }

        public static String getOBCPackageName() {
            return "org.bukkit.craftbukkit" + Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        }

        public static Object bukkitPlayerToEntityPlayer(Player player) {
            Object entityPlayer = null;
            try {
                entityPlayer = BarReflectionUtils.getMethod("getHandle", player.getClass(), 0).invoke((Object)player, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
            return entityPlayer;
        }
    }

    public static class FakeDragon {
        public static final int ENTITY_ID = 696969;
        public static final float MAX_HEALTH = 200.0f;
        private Player player;
        private String name = "null";
        private float health = 200.0f;
        private boolean invisible = false;
        private boolean exists = false;
        private LazyDataWatcher dataWatcher;

        public FakeDragon(Player player) {
            this.player = player;
        }

        public Player getPlayer() {
            return this.player;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.spawn();
            this.update();
        }

        public float getHealth() {
            return this.health;
        }

        public void setHealth(float health) {
            this.health = health;
            this.spawn();
            this.update();
        }

        public boolean isInvisible() {
            return this.invisible;
        }

        public void setInvisible(boolean invisible) {
            this.invisible = invisible;
            this.spawn();
            this.update();
        }

        public boolean doesExist() {
            return this.exists;
        }

        public void spawn() {
            if (!this.exists) {
                this.updateWatcher();
                LazyPacket mobSpawnPacket = new LazyPacket("PacketPlayOutSpawnEntity");
                Location loc = this.player.getLocation().clone().subtract(0.0, 200.0, 0.0);
                Vector velocity = new Vector(0, 0, 0);
                mobSpawnPacket.setPrivateValue("a", 696969);
                mobSpawnPacket.setPrivateValue("b", (byte)EntityType.ENDER_DRAGON.getTypeId());
                mobSpawnPacket.setPrivateValue("c", (int)Math.floor((double)loc.getBlockX() * 32.0));
                mobSpawnPacket.setPrivateValue("d", (int)Math.floor((double)loc.getBlockY() * 32.0));
                mobSpawnPacket.setPrivateValue("e", (int)Math.floor((double)loc.getBlockZ() * 32.0));
                mobSpawnPacket.setPrivateValue("f", (byte)(loc.getPitch() * 256.0f / 360.0f));
                mobSpawnPacket.setPrivateValue("g", (byte)0);
                mobSpawnPacket.setPrivateValue("h", (byte)(loc.getYaw() * 256.0f / 360.0f));
                mobSpawnPacket.setPrivateValue("i", (byte)velocity.getX());
                mobSpawnPacket.setPrivateValue("j", (byte)velocity.getY());
                mobSpawnPacket.setPrivateValue("k", (byte)velocity.getZ());
                mobSpawnPacket.setPrivateValue("t", this.dataWatcher.getDataWatcherObject());
                mobSpawnPacket.send(this.player);
                this.exists = true;
            }
        }

        public void destroy() {
            if (this.exists) {
                LazyPacket destroyEntityPacket = new LazyPacket("PacketPlayOutEntityDestroy");
                destroyEntityPacket.setPrivateValue("a", new int[]{696969});
                destroyEntityPacket.send(this.player);
                this.exists = false;
            }
        }

        public void update() {
            this.updateWatcher();
            if (this.exists) {
                LazyPacket metadataPacket = new LazyPacket("PacketPlayOutEntityMetadata");
                metadataPacket.setPrivateValue("a", 696969);
                Method watcherC = BarReflectionUtils.getMethod("c", this.dataWatcher.getDataWatcherObject().getClass());
                try {
                    metadataPacket.setPrivateValue("b", watcherC.invoke(this.dataWatcher.getDataWatcherObject(), new Object[0]));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                metadataPacket.send(this.player);
                LazyPacket teleportPacket = new LazyPacket("PacketPlayOutEntityTeleport");
                Location loc = this.player.getLocation().clone().subtract(0.0, 200.0, 0.0);
                teleportPacket.setPrivateValue("a", 696969);
                teleportPacket.setPrivateValue("b", (int)Math.floor((double)loc.getBlockX() * 32.0));
                teleportPacket.setPrivateValue("c", (int)Math.floor((double)loc.getBlockY() * 32.0));
                teleportPacket.setPrivateValue("d", (int)Math.floor((double)loc.getBlockZ() * 32.0));
                teleportPacket.setPrivateValue("e", (byte)(loc.getYaw() * 256.0f / 360.0f));
                teleportPacket.setPrivateValue("f", (byte)(loc.getPitch() * 256.0f / 360.0f));
                teleportPacket.send(this.player);
            }
        }

        public void updateWatcher() {
            this.dataWatcher = new LazyDataWatcher();
            this.dataWatcher.write(0, this.invisible ? Byte.valueOf((byte)32) : Byte.valueOf((byte)0));
            this.dataWatcher.write(6, Float.valueOf(this.health));
            this.dataWatcher.write(7, 0);
            this.dataWatcher.write(8, (byte)0);
            this.dataWatcher.write(10, this.name);
            this.dataWatcher.write(11, (byte)1);
        }

        private class LazyDataWatcher {
            private Object datawatcher;

            public LazyDataWatcher() {
                try {
                    this.datawatcher = BarReflectionUtils.getNMSClass("DataWatcher", new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void write(int i, Object object) {
                try {
                    Method method = this.datawatcher.getClass().getMethod("a", Integer.TYPE, Object.class);
                    method.invoke(this.datawatcher, i, object);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public Object getDataWatcherObject() {
                return this.datawatcher;
            }
        }

        private class LazyPacket {
            protected Object crafted_packet = null;

            public LazyPacket(String name) {
                try {
                    this.crafted_packet = BarReflectionUtils.getNMSClass(name, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void setPublicValue(String field, Object value) {
                try {
                    Field f = this.crafted_packet.getClass().getField(field);
                    f.setAccessible(true);
                    f.set(this.crafted_packet, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void setPrivateValue(String field, Object value) {
                try {
                    Field f = this.crafted_packet.getClass().getDeclaredField(field);
                    f.setAccessible(true);
                    f.set(this.crafted_packet, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public Object getPacketObject() {
                return this.crafted_packet;
            }

            public void send(Player player) {
                try {
                    Object entityPlayer = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
                    Object playerConnection = entityPlayer.getClass().getField("playerConnection").get(entityPlayer);
                    BarReflectionUtils.getMethod("sendPacket", playerConnection.getClass(), 1).invoke(playerConnection, this.crafted_packet);
                }
                catch (Exception e) {
                    Bukkit.getLogger().warning("Failed to send packet to player: " + player.getName() + "!");
                }
            }
        }
    }
}

