/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skriptaddon.skriptplus.elements.virtualchests;

import com.w00tmast3r.skriptaddon.skriptplus.SkriptPlus;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;

public class VirtualChestManager
implements Listener {
    private String inventoryName;
    private String player;
    private List<String>[] commands;

    public VirtualChestManager(String inventoryName, String player, List<String>[] commands) {
        this.inventoryName = inventoryName;
        this.player = player;
        this.commands = commands;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getCurrentItem() != null && e.getCurrentItem().getType() != Material.AIR && e.getInventory().getType() == InventoryType.CHEST && e.getInventory().getName().equalsIgnoreCase(this.inventoryName) && e.getWhoClicked().getName().equalsIgnoreCase(this.player)) {
            e.setCancelled(true);
            this.safeClose((Player)e.getWhoClicked());
            if (this.commands[e.getSlot()] != null) {
                for (String s : this.commands[e.getSlot()]) {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), s);
                }
            }
            HandlerList.unregisterAll((Listener)this);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        if (e.getPlayer().getName().equalsIgnoreCase(this.player) && e.getInventory().getName().equalsIgnoreCase(this.inventoryName)) {
            HandlerList.unregisterAll((Listener)this);
        }
    }

    private void safeClose(final Player p) {
        Bukkit.getScheduler().runTaskLater(SkriptPlus.me, new Runnable(){

            @Override
            public void run() {
                p.getOpenInventory().close();
            }
        }, 1L);
    }
}

