/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skriptaddon.skriptplus.elements.reflection;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.NoDoc;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

@NoDoc
public class ExprField
extends SimpleExpression<Object> {
    private Expression<String> xClass;
    private Expression<String> xField;

    protected Object[] get(Event event) {
        String xC = (String)this.xClass.getSingle(event);
        String xF = (String)this.xField.getSingle(event);
        if (xC == null || xF == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(xC);
            Field f = c.getDeclaredField(xF);
            f.setAccessible(true);
            if (Modifier.isStatic(f.getModifiers())) {
                return new Object[]{f.get(null)};
            }
            throw new IllegalAccessException();
        }
        catch (ClassNotFoundException ex) {
            Bukkit.getLogger().warning("Could not find class " + xC + ", aborting reflection");
        }
        catch (NoSuchFieldException ex) {
            Bukkit.getLogger().warning("Could not find field " + xF + " in class " + xC + ", aborting reflection");
        }
        catch (IllegalAccessException ex) {
            Bukkit.getLogger().warning("Could not access field " + xF + " because it is not static in class " + xC + ", aborting reflection");
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    public String toString(Event event, boolean b) {
        return "reflection, fields";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.xField = expressions[0];
        this.xClass = expressions[1];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Object o = delta[0];
        String xC = (String)this.xClass.getSingle(e);
        String xF = (String)this.xField.getSingle(e);
        if (xC == null || xF == null) {
            return;
        }
        try {
            Class<?> c = Class.forName(xC);
            Field f = c.getDeclaredField(xF);
            f.setAccessible(true);
            if (!Modifier.isStatic(f.getModifiers())) {
                throw new IllegalAccessException();
            }
            f.set(null, o);
        }
        catch (ClassNotFoundException ex) {
            Bukkit.getLogger().warning("Could not find class " + xC + ", aborting reflection");
        }
        catch (NoSuchFieldException ex) {
            Bukkit.getLogger().warning("Could not find field " + xF + " in class " + xC + ", aborting reflection");
        }
        catch (IllegalAccessException ex) {
            Bukkit.getLogger().warning("Could not access field " + xF + " because it is not static and is either private or protected in class " + xC + ", aborting reflection");
        }
    }
}

